
package com.eitima.HTTPServer;


import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

/**
 * Java Implementation of a basic HTTP server. 
 * Only Get method is implemented.
 * @author Eitima (Zexi Huang)
 * @version 1.0 Oct 16, 2016
 * Contact me via Eitima@163.com
 */
public class MyHTTPServer
{
	/**
	 * Main
	 * @param args
	 * @throws IOException 
	 */
	public static void main(String[] args) throws IOException
	{
		final int port =80;//set default port 80.
		new MyHTTPServer().start(port);
	}
	
	/**
	 * Create Server Socket and wait for clients.
	 * @param port
	 * @throws IOException
	 */
	public void start(int port) throws IOException
	{
		ServerSocket welcomingSocket=new ServerSocket(port);
		while(true)
		{
			Socket connectionSocket=welcomingSocket.accept();
			ServerThread serverThread=new ServerThread(connectionSocket);
			serverThread.start();
		}
	}
}
