%{
Read_Voice.m
Read wav format voices.
Zexi Huang
Dec.9 2016
%}


function [SigTime,t] = Read_Voice(sample_location)


[SigTimeD, Fs] =audioread(sample_location);


SigTime = SigTimeD(:,1);
SigTime=SigTime((0*Fs)+1:(6*Fs));
SigLength = length(SigTime); 



sound(SigTime, Fs);



t=(0:SigLength-1)/Fs; 
figure;
subplot(2,1,1);
plot(t, SigTime), title('Voice Wave'),grid;
xlabel('Time(s)');
ylabel('Amplitude');


Y = fft(SigTime,SigLength); 
Y=abs(Y);
f=(0:SigLength)* Fs/SigLength;
subplot(2,1,2);
plot(f,Y), title('Frequency Spectrum'),grid;
xlabel('Frequency(Hz)');
ylabel('Amplitude');


Y = fft(SigTime,SigLength); 
halfLength = floor(SigLength/2);
Pyy =Y(1:halfLength + 1); 
Pyy = abs(Pyy);
f = ((0:halfLength)+1)* Fs/SigLength; 
subplot(2,1,2);
plot(f,Pyy), title('Frequency spectrum'),grid;
xlabel('Frequency(Hz)');
ylabel('Amplitude');



Y = fft(SigTime,SigLength); 
halfLength = floor(SigLength/2);
SigFreqAmp =Y(1:halfLength + 1);
SigFreqAmp = abs(SigFreqAmp);
f = ((0:halfLength)+1)* Fs/SigLength; 
subplot(2,1,2);
plot(f,SigFreqAmp), title('Frequency Spectrum'),grid;
xlabel('Frequency(Hz)');
ylabel('Amplitude');
t=t';
f=f';

