%{
%Generating n Bernoulli random variables with probability of success p.
%Zexi Huang
%Oct. 4 2016
%} 

function Y=BernoulliGenerator(n,p)
%n: number of output random variables.
%p: probability of success.

%CDF of Bernoulli RV.
    function F=CDF(x)
        if x<0
            F=0;
        elseif x>=1
            F=1;
        else
            F=1-p;
        end
    end

%Numerical approach of the inverse CDF.
    function G=InverseCDF(u)
        x=[0,1];
        for s=x
            if CDF(s)>=u
                G=s;
                break;
            end
        end
    end

%Generation process
for ii=n:-1:1
    %Seemingly more efficient thant from 1 to n. Array size only changed
    %once in the loop.
    u=twister();
    Y(ii)=InverseCDF(u);
end

end


