%{
%Drawing normalized histogram derived from a sample of binomial distribution 
%and compare it with theoritic PMF.
%Zexi Huang
%Oct. 5 2016
%} 

function DrawingHistogram1(X, width)
%X: sample of random variables to be drawn.
%width: width of each bin.


%Produce histogram.
[nelements,xcenters]=hist(X,(range(X)+1)/width);
bar(xcenters,nelements/(width*length(X)),1);
xlabel('x');
ylabel('Relative Frequency');
hold on;

%Produce respective figure.
plot(40:80,binopdf(40:80,100,0.6),'r','LineWidth',1.5);
legend('Normalized histogram','Theoretic PMF');
title('Normalized Histogram of 1000 Binomial Random Samples');

hold off;


end
        