%{
%Generating N binomial random variables with parameter p and n.
%Zexi Huang
%Oct. 4 2016
%} 

function X=BinomialGenerator(N,n,p)
%N: number of output random variables.
%n: number of trials.
%p: probability of success.

%PMF of binomial RV.
    function f=PMF(x)
        f=nchoosek(n,x)*p^x*(1-p)^(n-x);
    end

%CDF of binomial RV (evaluation).
    function F=CDF(x)
        if x<0
            F=0;
        elseif x>n
            F=1;
        else
            F=0;
            for ii=1:floor(x)
                F=F+PMF(ii);
            end
        end
    end

%Numerical approach of the inverse CDF.
    function G=InverseCDF(u)
        x=0:n;
        for s=x
            if CDF(s)>u
                G=s;
                break;
            end
        end
    end

%Generation process
    %Seemingly more efficient thant from 1 to n. Array size only changed
    %once in the loop.
for jj=N:-1:1
    u=twister();
    X(jj)=InverseCDF(u);
end

end











