%{
%Drawing normalized histogram derived from two samples of normal distribution 
%and compare them with their theoritic PMF.
%Zexi Huang
%Oct. 5 2016
%} 

function DrawingHistogram2(Y1,Y2,width)
%Y1,Y2: sample of random variables to be drawn.
%width: width of each bin.

%Produce figure for Y1.
subplot(1,2,1);
[nelements,xcenters]=hist(Y1,(range(Y1)+1)/width);
bar(xcenters,nelements/(width*length(Y1)),1);
xlabel('y_1');
ylabel('Relative Frequency Density');
hold on;
plot(-5:0.01:7,normpdf(-5:0.01:7,1,2),'r','LineWidth',1.5);
legend('Normalized histogram','Theoretic PDF');
title('Normalized Histogram of 1000 Normal Random Samples, First Set');
%set(gca,'XTick',-10:1:10);
axis([-8 8 0 0.2]);


%Produce figure for Y2.
subplot(1,2,2);
[nelements,xcenters]=hist(Y2,(range(Y2)+1)/width);
bar(xcenters,nelements/(width*length(Y2)),1);
xlabel('y_2');
ylabel('Relative Frequency');
hold on;
plot(-5:0.01:7,normpdf(-5:0.01:7,1,2),'g','LineWidth',1.5);
legend('Normalized histogram','Theoretic PDF');
title('Normalized Histogram of 1000 Normal Random Samples, Second Set');
%set(gca,'XTick',-10:1:10);
axis([-8 8 0 0.2]);

hold off;


end
        