%{
%Independent test between two normal random samples.
%Zexi Huang
%Oct. 6 2016
%} 

function [table,h,p]=IndependenceTest(Y1,Y2)
%Y1, Y2: two sets random samples to be tested.
%table: the output contigency table.
%h: whether the test is rejected, 1 indicates rejected.
%p: p-value of the test.

%Computing mean, sample standard deviation and lengths of Y1, Y2
[m1,v1]=MeanVariance(Y1);
[m2,v2]=MeanVariance(Y1);
s1=sqrt(v1);
s2=sqrt(v2);
n1=numel(Y1);
n2=numel(Y2);

%Replacing values with category labels.
for ii=1:n1
    if(Y1(ii)<m1-2*s1)
        Y1(ii)=1;
    elseif(Y1(ii)<m1-s1)
        Y1(ii)=2;
    elseif(Y1(ii)<m1)
        Y1(ii)=3;
    elseif(Y1(ii)<m1+s1)
        Y1(ii)=4;
    elseif(Y1(ii)<m1+2*s1)
        Y1(ii)=5;
    else
        Y1(ii)=6;
    end
end

for ii=1:n2
    if(Y2(ii)<m2-2*s2)
        Y2(ii)=1;
    elseif(Y2(ii)<m2-s2)
        Y2(ii)=2;
    elseif(Y2(ii)<m2)
        Y2(ii)=3;
    elseif(Y2(ii)<m2+s2)
        Y2(ii)=4;
    elseif(Y2(ii)<m2+2*s2)
        Y2(ii)=5;
    else
        Y2(ii)=6;
    end 
end


%Produce the contigency table and do the chi2 test.
[table,chi2,p]=crosstab(Y1,Y2);

if(p<0.05)
    h=1;
else
    h=0;
end

end
































































































