%{
%Non-parameter hypothesis test for good of fit and independence.
%Zexi Huang
%Oct. 5 2016
%} 

function [h,p]=NonParametricHypothesisTest(X,mode)
%X: sample of random variables to be tested.
%mode: determines which test is used.
%h: whether the test is rejected, 1 indicates rejected.
%p: p-value of the test.

%Generate standard pdf.
switch mode
    case{1}
        pd=makedist('Binomial','N',100,'p',0.6);
        [h,p]=chi2gof(X,'CDF',pd,'Ctrs',[45,50,55,60,65,70,75]);
    case{2}
        pd=makedist('Normal','mu',1,'sigma',2);
        [h,p]=chi2gof(X,'CDF',pd);
        
end

%Hypothesis test.



