%{
CompareDifferentParameters.m
Draw figures for comparision of different windows, without considering the
spectrum leakage avoidance.
Zexi Huang
Dec.23 2016
%}
function CompareDifferentParameters(M,N)
%M: length of the window.
%N: length of DFT.

subplot(2,2,1);
FrequencyAnalyzer('R',M,N);
xlim([1.2 1.5]);
title(['(a) Frequency Spectrum of x_w[n] with Rectangular Window. M=',num2str(M),' N=',num2str(N)]);

subplot(2,2,2);
FrequencyAnalyzer('N',M,N);
xlim([1.2 1.5]);
title(['(b) Frequency Spectrum of x_w[n] with Hann Window. M=',num2str(M),' N=',num2str(N)]);

subplot(2,2,3);
FrequencyAnalyzer('M',M,N);
xlim([1.2 1.5]);
title(['(c) Frequency Spectrum of x_w[n] with Hamming Window. M=',num2str(M),' N=',num2str(N)]);

subplot(2,2,4);
FrequencyAnalyzer('B',M,N);
xlim([1.2 1.5]);
title(['(d) Frequency Spectrum of x_w[n] with Blackman Window. M=',num2str(M),' N=',num2str(N)]);