%{
FrequencyAnalyzer.m
Draw the frequency spectrum of the given signal, with different parameters
of windows and DFT.
Zexi Huang
Dec.22 2016
%}
function FrequencyAnalyzer(windowType,M,N)
%windowType: type of the window choosen, 'R' for Rectangular, 'N' for
%haNn, 'M' for haMming, 'B' for Blackman.
%M: length of the window.
%N: length of DFT.
%f0: number of frequency components detected.
%f: detected frequency.

%Generate the sampled signal.
n=0:1:M-1;
x=10*sin(2*pi*64/1200*n)+sin(2*pi*(250)/1200*n)+20*sin(2*pi*256/1200*n)+3*sin(2*pi*260/1200*n)+10*sin(2*pi*512/1200*n);

%Generate the window function.
switch windowType
    case 'R'
        w=rectwin(M);
    case 'N'
        w=hann(M);
    case 'M'
        w=hamming(M);
    case 'B'
        w=blackman(M);
end

%The windowed signal.
x_w=x.*w';
X_W=fft(x_w,N)/(N/2);
X_W=abs(X_W);
omega=0:2*pi/N:2*pi*(1-1/N);

%Draw the figure for results.
stem(omega,X_W);
xlim([0 pi]);
xlabel('Digital Radian Frequency (rad/sample)');
ylabel('Amplitude');


        

