%{
WindowDrawer.m
Drawing the spectrum of given window funcitons.
Zexi Huang
Dec.22 2016
%}
function WindowDrawer(M)
%M: Length of each window.

%Rectangular window.
subplot(2,2,1);
w=rectwin(M);
[W,omega]=freqz(w,1,8*M);
W=abs(W);
W=W/max(W);
plot(omega,20*log10(W));
axis([0 pi -100 0]);
title('(a) Gain Response of Rectangular Window');
xlabel('Digital Radian Frequency (rad/sample)');
ylabel('Gain/dB');

%Hann window.
subplot(2,2,2);
w=hann(M);
[W,omega]=freqz(w,1,8*M);
W=abs(W);
W=W/max(W);
plot(omega,20*log10(W));
axis([0 pi -100 0]);
title('(b) Gain Response of Hann Window');
xlabel('Digital Radian Frequency (rad/sample)');
ylabel('Gain/dB');

%Hamming window.
subplot(2,2,3);
w=hamming(M);
[W,omega]=freqz(w,1,8*M);
W=abs(W);
W=W/max(W);
plot(omega,20*log10(W));
axis([0 pi -100 0]);
title('(c) Gain Response of Hamming Window');
xlabel('Digital Radian Frequency (rad/sample)');
ylabel('Gain/dB');

%Blackman window.
subplot(2,2,4);
w=blackman(M);
[W,omega]=freqz(w,1,8*M);
W=abs(W);
W=W/max(W);
plot(omega,20*log10(W));
axis([0 pi -100 0]);
title('(d) Gain Response of Blackman Window');
xlabel('Digital Radian Frequency (rad/sample)');
ylabel('Gain/dB');


