%{
%Generating n0=400 samples of cosine sequence given digital radian frequency w.
%Zexi Huang
%Dec. 14 2016
%}

function h=CosineGenerator(w,n0)
%h: output, n0=400 samples of the required cosine sequence.
%p: digital radian frequency of the cosine sequence.


C=cos(w);
%Store the constant.
h=zeros(n0,1)';
%Initiate h.


h(1)=1;
%Note that it in fact computes h[0], that is, h[n]=h(n+1) since MATLAB
%don't allow zero index.
h(2)=C;
%Initial condition computed from h(-2)=h(-1)=0

for ii=3:1:n0
    h(ii)=2*C*h(ii-1)-h(ii-2);
end
%Loop implementation of recursive evaluation.
           
end
        