%{
%Identify the respective key for a given DTMF signal.
%Zexi Huang
%Dec. 15 2016
%}

function key=DTMFDetector(x,t)
%[x,t]: input DTMF sequence.
%key: the key pressed identified.

%Computing DTFT of the sequence based on Goertzel's algorithm.
[X,w]=GoertzelDFT(x);
%Mapping DTFT to CTFT samples.
[X,w]=DTFTtoCTFT(X,w);
%Identify local maxima of the sequence.
[maxX,maxw]=LocalMaximaIdentifier(X,w);

%Identified fl and fh.
fl0=maxw(1);
fh0=maxw(2);

%fl and fh sets.
fl=[697, 770, 852, 941];
fh=[1209, 1336, 1477, 1633];

%Difference between identified fl, fh and fl, fh sets.
fl0=fl0*ones(1,4);
fh0=fh0*ones(1,4);
fl_diff=abs(fl-fl0);
fh_diff=abs(fh-fh0);

%Mapping identified frequency back to key pressed.
if min(fl_diff)==fl_diff(1)
    if min(fh_diff)==fh_diff(1)
        key='1';
    elseif min(fh_diff)==fh_diff(2)
        key='2';
    elseif min(fh_diff)==fh_diff(3)
        key='3';
    elseif min(fh_diff)==fh_diff(4)
        key='A';
    end
elseif min(fl_diff)==fl_diff(2)
    if min(fh_diff)==fh_diff(1)
        key='4';
    elseif min(fh_diff)==fh_diff(2)
        key='5';
    elseif min(fh_diff)==fh_diff(3)
        key='6';
    elseif min(fh_diff)==fh_diff(4)
        key='B';
    end    
elseif min(fl_diff)==fl_diff(3)
    if min(fh_diff)==fh_diff(1)
        key='7';
    elseif min(fh_diff)==fh_diff(2)
        key='8';
    elseif min(fh_diff)==fh_diff(3)
        key='9';
    elseif min(fh_diff)==fh_diff(4)
        key='C';
    end    
elseif min(fl_diff)==fl_diff(4)
    if min(fh_diff)==fh_diff(1)
        key='*';
    elseif min(fh_diff)==fh_diff(2)
        key='0';
    elseif min(fh_diff)==fh_diff(3)
        key='#';
    elseif min(fh_diff)==fh_diff(4)
        key='D';
    end    
end

