%{
%Generating a DTMF sequence with specified key pressed based on digital
oscillator.
%Zexi Huang
%Dec. 14 2016
%}

function [x,t]=DTMFGenerator(key)
%key: input key.
%[x,t]: output respective DTMF sequence.

fs=8000;
n0=400;

%List required frequencies.
fl=[697, 770, 852, 941];
fh=[1209, 1336, 1477, 1633];

%Generate time stamps.
t=0:1/8:50-1/8;


%Establish mapping relations.
switch key
    case '1' 
        wl=fl(1);
        wh=fh(1);
    case '2' 
        wl=fl(1);
        wh=fh(2);
    case '3' 
        wl=fl(1);
        wh=fh(3);        
    case 'A' 
        wl=fl(1);
        wh=fh(4);
    case '4' 
        wl=fl(2);
        wh=fh(1);        
    case '5' 
        wl=fl(2);
        wh=fh(2);        
    case '6' 
        wl=fl(2);
        wh=fh(3);        
    case 'B' 
        wl=fl(2);
        wh=fh(4);        
    case '7' 
        wl=fl(3);
        wh=fh(1);        
    case '8' 
        wl=fl(3);
        wh=fh(2);        
    case '9' 
        wl=fl(3);
        wh=fh(3);        
    case 'C' 
        wl=fl(3);
        wh=fh(4);      
    case '*' 
        wl=fl(4);
        wh=fh(1);          
    case '0' 
        wl=fl(4);
        wh=fh(2);          
    case '#' 
        wl=fl(4);
        wh=fh(3);          
    case 'D' 
        wl=fl(4);
        wh=fh(4);          
end

wl=2*pi*wl/fs;
wh=2*pi*wh/fs;

%Calling digital oscillator based cosine generator.
x=CosineGenerator(wl,n0)+CosineGenerator(wh,n0);

sound(x,fs);
end
        