%{
%Goertzel's Algorithm to compute DFT for given sequence.
%Zexi Huang
%Dec. 14 2016
%}

function [X,w]=GoertzelDFT(x)
%[X,w]: output DTFT samples.
%x: input sequence.


%N: Number of samples.
N=400;

%Generate frequency stamps.
w=0:2*pi/N:2*pi*(1-1/N);

%Initiate X.
X=zeros(N,1)';

%Generate X[k].
for k=0:1:N-1
    %Store the constant.
    C=2*cos(2*pi*k/N);
    %Initiate vk.
    vk=zeros(N+1,1)';
    
    %vk[0], vk[1] computed from vk[-2], vk[-1].
    vk(1)=x(1);
    vk(2)=x(2)+C*vk(1);
    
    for ii=3:1:N
        vk(ii)=x(ii)+C*vk(ii-1)-vk(ii-2);
    end
    vk(N+1)=C*vk(N)-vk(N-1);
    %In fact X(k).
    X(k+1)=vk(N+1)^2+vk(N)^2-C*vk(N+1)*vk(N);
end

    
