%{
createf.m
Create the figure for respective order of fitting.
Zexi Huang
Dec 11th 2016
%}

function createf(order,Donation,Performance)
%order: The order of poly fitting.
%:Donation: The present donation for respective university.
%:Performance: The present students' performance for respective university.

order=num2str(order);

[xData, yData] = prepareCurveData( Donation, Performance );

% Set up fittype and options.
ft = fittype( ['poly',order] );

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft );

% Plot fit with data.
figure( 'Name', 'untitled fit 1' );
h = plot( fitresult, xData, yData );
legend( h, 'Performance vs. Donation', 'Fit curve', 'Location', 'SouthEast' );
title(['Curve Fitting Between Donation and Performance, Order=',order]);
% Label axes
xlabel Donation;
ylabel Performance;
xlim([0 2]);
ylim([0 1]);
grid on