package uestc.dm.GILPA_Energy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.omg.CORBA.LongHolder;



public class GILPA
{
	private List<Node> nodeSet=new ArrayList<>();
	private List<Edge> edgeSet=new ArrayList<>();
	private List<Community> communitySet=new ArrayList<>();
	
	/**
	 * number of nodes and edges, respectively.
	 */
	private int n;
	private int m;
	
	/**
	 *The checker for stop criteria. 
	 */
	private List<Checker> lastCheckerSet=new ArrayList<>();
	private List<Checker> checkerSet=new ArrayList<>();
	/**
	 * The C Checker for stop criteria.
	 */
	private List<Checker> lastCCheckerSet=new ArrayList<>();
	private List<Checker> cCheckerSet=new ArrayList<>();
	/**
	 * The global E modularity and Ni modularity.
	 */
	private double modularityNi;
	private double modularityE;
	
	/**
	 * Total number of labels in the graph.
	 */
	private int numberOfLabels;
	
	/**
	 * Read the data from file, load them into the nodeSet and edgeSet.
	 * @param filepath
	 */
	public void readData(String filepath)
	{
		//Read the nodes and edges.
		File inputFile=new File(filepath);
		InputStream inputStream = null;
		try
		{
			inputStream=new FileInputStream(inputFile);
		} catch (FileNotFoundException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		InputStreamReader inputStreamReader= new InputStreamReader(inputStream);
		BufferedReader bufferedReader=new BufferedReader(inputStreamReader);
		String string;
		
		try
		{
			while((string=bufferedReader.readLine())!=null)
			{
				if(string.trim().equals("node"))
				{
					bufferedReader.readLine();//skip "["
					int id=Integer.parseInt((bufferedReader.readLine().trim()).split(" ")[1]);
					String label;
					if((label=bufferedReader.readLine()).contains("label"))
					{
						String labelTrimmed=label.trim();
						int labelSize=labelTrimmed.split(" ").length;
						label=labelTrimmed.split(" ")[1];
						for(int i=2;i<labelSize;i++)
						{
							label=label+" "+labelTrimmed.split(" ")[i];
						}
						bufferedReader.readLine();//skip "]"
					}
					else
						label=null;
					nodeSet.add(new Node(id, label));
				}
				if(string.trim().equals("edge"))
				{
					bufferedReader.readLine();//skip "["
					int sourceId=Integer.parseInt((bufferedReader.readLine().trim()).split(" ")[1]);
					int targetId=Integer.parseInt((bufferedReader.readLine().trim()).split(" ")[1]);
					String value;
					double weight;
					if((value=bufferedReader.readLine()).contains("value"))
					{
						weight=Double.parseDouble(value.trim().split(" ")[1]);
						bufferedReader.readLine();//skip "]"
					}
					else
						weight=1.0;
					edgeSet.add(new Edge(sourceId, targetId, nodeSet, weight));
				}
			}
		} catch (IOException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		//Find the neighbors for each node. Add the edges to the local edge sets.
		for (Edge edge:edgeSet)
		{
			edge.getSource().getAllNeighbors().add(edge.getTarget());
			edge.getSource().getAllEdges().add(edge);
			edge.getTarget().getAllNeighbors().add(edge.getSource());
			edge.getTarget().getAllEdges().add(edge);
		}
		
		//Compute the degree for each node.
		for (Node node : nodeSet)
		{
			node.computeDegree();
		}
		
		//Compute the similarity between the connected nodes.
		for (Edge edge:edgeSet)
		{
			edge.computeSimilarity();
		}
		
		//Compute number of nodes and edges of the graph.
		n=nodeSet.size();
		m=edgeSet.size();
		
	}
	
	/**
	 * Initialize each community with a single node.
	 */
	public void initialize()
	{
		for(Node node:nodeSet)
		{
			List<Node> allnodes=new ArrayList<>();
			allnodes.add(node);
			Community community=new Community(node.getId(),allnodes);
			communitySet.add(community);
			
			node.getAllLabels().add(new Label(community, 1.0));
		}
		//Compute the initial checker.
		for(Community community:communitySet)
		{
			lastCheckerSet.add(new Checker(community, community.getAllNodes().size()));
			lastCCheckerSet.add(new Checker(community, community.getAllNodes().size()));
		}
		//Compute the initial global statistics.
		for(Community community:communitySet)
		{
			community.updatePhi();
			community.updatePsi();
		}
		//Compute initial modularity
		modularityE=Functions.computeModularityE(nodeSet, m);
		modularityNi=Functions.computeModularityNi(nodeSet, n, m);
		
		//Compute initial number of labels.
		numberOfLabels=Functions.numberOfLabels(nodeSet);
	}
	
	/**
	 * Nodes begin to interact with each other, i.e., propagate labels.
	 */
	public void interact()
	{
		boolean loopFlag=true;
		int loop=0;
		boolean hasMemory=true;
		
		//If the node has memory, then we fix the number of iterations as 100, otherwise the COPRA stopping criteria is applied.
		while(((!hasMemory)&&(loop<2||loopFlag))||(hasMemory&&loop<143))
//		while(loop<100)
		{

			System.out.println("loop:"+loop);
			
			System.out.println("ModularityNi:"+modularityNi);
			System.out.println("ModularityE:"+modularityE);
			System.out.println("LabelSize:"+communitySet.size());
			loop++;
			
			if(loop==1000)
			{
				System.out.println("Hard to converge.");
				break;
			}


			
			

			
			//Compute the labels at next state for each node.
			for(Node node:nodeSet)
			{
				//Sum the labels from neighbors.
				List<Node> allNeighbors=node.getAllNeighbors();
				List<Edge> allEdges=node.getAllEdges();
				List<Label>nextStateAllLabels=node.getNextStateAllLabels();
				
				List<Label> allLabels=node.getAllLabels();
				
				//For node that is not connected to any other nodes.
				if(allNeighbors.isEmpty())
				{
					for(Label label: allLabels)
					{
						nextStateAllLabels.add(label);
					}
				}

				for(Node neighbor:allNeighbors)
				{
					//Get similarity between the nodes.
					double similarity=0;
					for(Edge edge:allEdges)
					{
						//Can be improved.
						if(((edge.getSource()==node)&&(edge.getTarget()==neighbor)) ||((edge.getSource()==neighbor)&&(edge.getTarget()==node)))
						{
							similarity=edge.getSimilarity();
							break;
						}
					}
					
					
//					similarity=1;
					

					List<Label>neighborAllLabels=neighbor.getAllLabels();
					
					List<LabelWithCost> allLabelsWithCost=new ArrayList<>();
					
					CostGenerationTechniques.maximalTwoLabelsCost(allLabelsWithCost, node, neighbor);
//					CostGenerationTechniques.absoluteDifferenceCost(allLabelsWithCost, node, neighbor);
//					CostGenerationTechniques.minimalAbsoluteDifferenceCost(allLabelsWithCost, node, neighbor);

					
					
					//Sort cost into ascending order.
					Collections.sort(allLabelsWithCost);
					
					//Use energy to restrict the number of labels to be transfered.
					double totalEnergy=1;
					Iterator<LabelWithCost> iterator=allLabelsWithCost.iterator();
					
//					int numberOfLabelsTransfered=0;
					
					while(iterator.hasNext())
					{
						LabelWithCost labelWithCost=(LabelWithCost)iterator.next();
						if(totalEnergy-labelWithCost.getCost()<0)
							break;
						else 
							totalEnergy=totalEnergy-labelWithCost.getCost();
						
//						numberOfLabelsTransfered++;
						
						//Check whether the label from the neighbor exists in the current next state labels.
						boolean labelNotIn=true;
						for(Label nextStateLabel:nextStateAllLabels)
						{
							if(nextStateLabel.getCommunity()==labelWithCost.getLabel().getCommunity())
								{
									labelNotIn=false;
									nextStateLabel.setCoefficient(nextStateLabel.getCoefficient()+labelWithCost.getLabel().getCoefficient()*similarity);
									break;
								}
						}
						if(labelNotIn)
						{
							nextStateAllLabels.add(new Label(labelWithCost.getLabel().getCommunity(), labelWithCost.getLabel().getCoefficient()*similarity));
						}
					}
					
//					if(numberOfLabelsTransfered>2)
//					{
//						System.out.println(numberOfLabelsTransfered);
//					}
		
				}
				Functions.renormalize(nextStateAllLabels);
				
				//Adding present state labels to next state labels.

				if(hasMemory)
				{
					for(Label label:allLabels)
					{
						boolean labelNotIn=true;
						for(Label nextStateLabel:nextStateAllLabels)
						{
							if(nextStateLabel.getCommunity()==label.getCommunity())
							{
								nextStateLabel.setCoefficient(nextStateLabel.getCoefficient()+label.getCoefficient());
								labelNotIn=false;
								break;
							}
						}
						if(labelNotIn)
						{
							nextStateAllLabels.add(label);
						}
					}
				}
				
				Functions.renormalize(nextStateAllLabels);

				
				
				

			}
			//Adding nodes into community next state members.
			for(Node node:nodeSet)
			{
				List<Label> allLabels=node.getNextStateAllLabels();
				for(Label label:allLabels)
				{
					label.getCommunity().getNextStateAllNodes().add(node);
				}
			}

			//Synchronous update for labels.
			for(Node node:nodeSet)
			{
				node.getAllLabels().clear();
				List<Label> nextStateAllLabels=node.getNextStateAllLabels();;
				for(Label label:nextStateAllLabels)
				{
					node.getAllLabels().add(label);
				}
				node.getNextStateAllLabels().clear();
			}
			//Synchronous update for community members.
			for(Community community:communitySet)
			{
				community.getAllNodes().clear();
				List<Node> nextStateAllNodes=community.getNextStateAllNodes();
				for(Node node:nextStateAllNodes)
				{
					community.getAllNodes().add(node);
				}
				community.getNextStateAllNodes().clear();
			}
			//Remove labels that are already eliminated from the community set.
			Iterator<Community> iterator=communitySet.iterator();
			while (iterator.hasNext())
			{
				Community community = (Community) iterator.next();
				if(community.getAllNodes().isEmpty())
					iterator.remove();
			}
			
			//Compute the C checkers after update.
			int numberOfCommunity=communitySet.size();
			int lastNumberOfCommunity=lastCCheckerSet.size();
			
			for(Community community:communitySet)
			{
				cCheckerSet.add(new Checker(community, community.getAllNodes().size()));
			}
			
			//Compute the checkers for this state.
			if(lastNumberOfCommunity==numberOfCommunity)//Since the number of communities stay the same,
				//the sequence of the communities in both C checkers should also be the same.
			{
				for(int i=0;i<numberOfCommunity;i++)
				{
					int numberOfNodes;
					if(lastCCheckerSet.get(i).getNumberOfNodes()<cCheckerSet.get(i).getNumberOfNodes())
						numberOfNodes=lastCCheckerSet.get(i).getNumberOfNodes();
					else
						numberOfNodes=cCheckerSet.get(i).getNumberOfNodes();
					checkerSet.add(new Checker(lastCCheckerSet.get(i).getCommunity(), numberOfNodes));
				}
			}
			else
			{
				for(Checker checker:cCheckerSet)
				{
					checkerSet.add(checker);
				}
			}
			
			//Determine the loop criteria.
			if(lastCheckerSet.size()!=checkerSet.size())
				loopFlag=true;
			else 
			{
				loopFlag=false;
				for(int i=0;i<lastCheckerSet.size();i++)
				{
					if(!lastCheckerSet.get(i).equals(checkerSet.get(i)))
						loopFlag=true;
				}
			}
			
			//Update the checker set.
			lastCheckerSet.clear();
			for(Checker checker:checkerSet)
			{
				lastCheckerSet.add(checker);
			}
			checkerSet.clear();
			lastCCheckerSet.clear();
			for(Checker checker:cCheckerSet)
			{
				lastCCheckerSet.add(checker);
			}
			cCheckerSet.clear();
			
			//Update the global statistics.
			for(Community community:communitySet)
			{
				community.updatePhi();
				community.updatePsi();
			}
			//Update global modularity.
			modularityE=Functions.computeModularityE(nodeSet, m);
			modularityNi=Functions.computeModularityNi(nodeSet, n, m);
			//Update total number of labels.
			numberOfLabels=Functions.numberOfLabels(nodeSet);

		}
		System.out.println("loop:"+loop);
		System.out.println("ModularityNi:"+modularityNi);
		System.out.println("ModularityE:"+modularityE);
		System.out.println("LabelSize:"+communitySet.size());
	}
	
	/**
	 * Print the results into the file in the same directory with a _result suffix and txt format.
	 * In this file, each line consists of a node (its id and label) and a set of tuples (community_id, coefficient), separated by "\t".
	 * Also print the results into the file in the same directory with a _community suffix and txt format.
	 * In this file, each line consists of a community (its id) and all the nodes in one community along with their belong coefficient (node_id, coefficient), separated by "\t".
	 * @param filepath
	 */
	public void produceCommunity(String filepath)
	{
		//Output the _result file. 
		File outputFile=new File(filepath.split("\\.")[0]+"_result.txt");
		try
		{
			outputFile.createNewFile();
		} catch (IOException e2)
		{
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}
		OutputStream outputStream=null;
		try
		{
			outputStream=new FileOutputStream(outputFile);
		} catch (FileNotFoundException e1)
		{
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
		OutputStreamWriter outputStreamWriter=new OutputStreamWriter(outputStream);
		BufferedWriter bufferedWriter=new BufferedWriter(outputStreamWriter);
		
		for(Node node:nodeSet)
		{
			try
			{
				//Suppress NodeId for benchmark networks.
				bufferedWriter.write(node.getId()+"\t");
				
				
				if(node.getLabel()!=null)
				{
					bufferedWriter.write(node.getLabel()+"\t");
				}
				List<Label> allLabels=node.getAllLabels();
				for(Label label:allLabels)
				{
					bufferedWriter.write("("+label.getCommunity().getId()+","+label.getCoefficient()+")\t");
					bufferedWriter.flush();
				}
				bufferedWriter.newLine();
				bufferedWriter.flush();
				
			} catch (IOException e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		//Output the _community file.
		outputFile=new File(filepath.split("\\.")[0]+"_community.txt");
		try
		{
			outputFile.createNewFile();
		} catch (IOException e2)
		{
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}
		try
		{
			outputStream=new FileOutputStream(outputFile);
		} catch (FileNotFoundException e1)
		{
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
		outputStreamWriter=new OutputStreamWriter(outputStream);
		bufferedWriter=new BufferedWriter(outputStreamWriter);
		
		for(Community community:communitySet)
		{
			try
			{
				bufferedWriter.write(community.getId()+"\t");
				bufferedWriter.flush();
			} catch (IOException e1)
			{
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			
			List<Node> allNodes=community.getAllNodes();
			for(Node node:allNodes)
			{
				List<Label> allLabels=node.getAllLabels();
				for(Label label:allLabels)
				{
					if(label.getCommunity()==community)
					{
						try
						{
							bufferedWriter.write("("+node.getId()+","+label.getCoefficient()+")\t");
							bufferedWriter.flush();
						} catch (IOException e)
						{
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				}
			}
			try
			{
				bufferedWriter.newLine();
				bufferedWriter.flush();
			} catch (IOException e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}		

		//Output the _NMI file for computing NMI.
		outputFile=new File(filepath.split("\\.")[0]+"_NMI.dat");
		try
		{
			outputFile.createNewFile();
		} catch (IOException e2)
		{
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}
		try
		{
			outputStream=new FileOutputStream(outputFile);
		} catch (FileNotFoundException e1)
		{
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
		outputStreamWriter=new OutputStreamWriter(outputStream);
		bufferedWriter=new BufferedWriter(outputStreamWriter);
		
		for(Community community:communitySet)
		{
			List<Node> allNodes=community.getAllNodes();
			for(Node node:allNodes)
			{
				try
				{
					bufferedWriter.write(node.getLabel()+" ");
					bufferedWriter.flush();
				} catch (IOException e)
				{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			try
			{
				bufferedWriter.newLine();
				bufferedWriter.flush();
			} catch (IOException e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}		

		
		
		try
		{
			bufferedWriter.close();
		} catch (IOException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	/**
	 * Deleting nested communities.
	 */
	public void postprocess()
	{
		
		//Deleting the label for the subset community for the node. 
		//Add the coefficient of this label to all the superset communities averagely. 
		Collections.sort(communitySet);
		Iterator<Community> outIterator=communitySet.iterator();
		while (outIterator.hasNext())
		{
			Community theCommunity = (Community) outIterator.next();
			Iterator<Community> inIterator=communitySet.iterator();
			Community community=new Community();
			
			List<Community> supersetCommunities=new ArrayList<>();
			
			while (inIterator.hasNext()&&((community=inIterator.next())!=theCommunity))
			{
				if(theCommunity.isSubsetOf(community))
				{
					supersetCommunities.add(community);
				}	
			}
			if(!supersetCommunities.isEmpty())
			{
				List<Node> allNodes=theCommunity.getAllNodes();
				for(Node node:allNodes)
				{
//					if(node.getId()==27&&theCommunity.getId()==30)
//					{
//						System.out.println("Check!");
//					}
					
					
					List<Label> labels=node.getAllLabels();
					double coefficient=0;
					//Delete the subset for the node.
					Iterator<Label> labelIterator=labels.iterator();
					while (labelIterator.hasNext())
					{
						Label label = (Label) labelIterator.next();
						if(label.getCommunity()==theCommunity)
						{
							coefficient=label.getCoefficient();
							labelIterator.remove();
						}
					}
					//Add the coefficient to the superset.
					for (Label label : labels)
					{
						if(supersetCommunities.contains(label.getCommunity()))
						{
							label.setCoefficient(label.getCoefficient()+coefficient/supersetCommunities.size());
						}
					}
				}
				//Delete the subset community from the communitySet.
				outIterator.remove();
			}
		}
		//Update the global statistics.
		for(Community community:communitySet)
		{
			community.updatePhi();
			community.updatePsi();
		}
		
		System.out.println("Final Label Size:"+communitySet.size());
		System.out.println("Final ModularityNi:"+(modularityNi=Functions.computeModularityNi(nodeSet, n, m)));
		System.out.println("Final ModularityE:"+(modularityE=Functions.computeModularityE(nodeSet,  m)));
	}
	public void dropLabels()
	{
		double cumulativeThreshold=0.8;
		LabelDroppingTechniques.cumulativeCoefficientDrop(nodeSet, cumulativeThreshold);
		
//		double singleThreshold=0.1;
//		LabelDroppingTechniques.singleThresholdDrop(nodeSet, singleThreshold);
		
		
		//Update information for communitySet.
		for(Community community:communitySet)
			community.getAllNodes().clear();
		
		for(Node node:nodeSet)
		{
			List<Label> allLabels=node.getAllLabels();
			for(Label label:allLabels)
				label.getCommunity().getAllNodes().add(node);
		}
		
		//Delete communities that already have no elements.
		Iterator<Community> iterator=communitySet.iterator();
		while (iterator.hasNext())
		{
			Community community = (Community) iterator.next();
			if(community.getAllNodes().isEmpty())
				iterator.remove();
		}
		
		//Update the global statistics.
		for(Community community:communitySet)
		{
			community.updatePhi();
			community.updatePsi();
		}
	}
	public void communityDetection(String filepath)
	{
		readData(filepath);
		initialize();
		interact();
		dropLabels();
		postprocess();
		produceCommunity(filepath);
	}

	public static void main(String[] args)
	{
		//Real Networks.
//		String filepath="E:\\Files_Own\\Project\\Data_Mining\\Dynamics\\Source\\DataSet\\karate.gml";
//		String filepath="E:\\Files_Own\\Project\\Data_Mining\\Dynamics\\Source\\DataSet\\dolphins.gml";
//		String filepath="E:\\Files_Own\\Project\\Data_Mining\\Dynamics\\Source\\DataSet\\football.gml";
//		String filepath="E:\\Files_Own\\Project\\Data_Mining\\Dynamics\\Source\\DataSet\\netscience.gml";
//		String filepath="E:\\Files_Own\\Project\\Data_Mining\\Dynamics\\Source\\DataSet\\cond-mat-2005.gml";
		
		//Benchmark Networks.
//		String filepath="E:\\Files_Own\\Project\\Data_Mining\\Dynamics\\Source\\Benchmark\\binary_networks\\binary_networks\\default benchmark\\network.gml";
//		String filepath="E:\\Files_Own\\Project\\Data_Mining\\Dynamics\\Source\\Benchmark\\binary_networks\\binary_networks\\small network size\\network.gml";
		String filepath="E:\\Files_Own\\Project\\Data_Mining\\Dynamics\\Source\\Benchmark\\binary_networks\\binary_networks\\big community size\\network.gml";
	

		

		GILPA gilpa=new GILPA();
		gilpa.communityDetection(filepath);
	}

}
