package uestc.dm.GILPA_Energy;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LabelDroppingTechniques
{
	//Summing labels from high coefficient to small coefficient, until the sum exceeds 
	//a certain threshold. Deleting the rest of the labels. And then normalize.
	public static void cumulativeCoefficientDrop(List<Node> nodeSet, double cumulativeThreshold)
	{
		for(Node node:nodeSet)
		{
			List<Label> allLabels=node.getAllLabels();
			Collections.sort(allLabels);
			
			Iterator<Label> iterator=node.getAllLabels().iterator();
			double sum=0;
			while (iterator.hasNext()&&sum<cumulativeThreshold)
			{
				Label label = (Label) iterator.next();
				sum=sum+label.getCoefficient();
			}
			while(iterator.hasNext())
			{
				iterator.next();
				iterator.remove();
			}
			Functions.renormalize(allLabels);
		}
	}
	
	public static void singleThresholdDrop(List<Node> nodeSet, double singleThreshold)
	{
		for(Node node:nodeSet)
		{
			List<Label> allLabels=node.getAllLabels();
			
			Iterator<Label> iterator=node.getAllLabels().iterator();
			while (iterator.hasNext())
			{
				Label label = (Label) iterator.next();
				if(label.getCoefficient()<singleThreshold)
					iterator.remove();
			}
			Functions.renormalize(allLabels);
		}
	}
	

	

}
