package uestc.dm.GILPA_Energy;

import java.util.ArrayList;
import java.util.List;


public class Node
{
	private int id;
	private String label;
	private int degree =0;

	
	
	private List<Node>allNeighbors=new ArrayList<>();
	private List<Label>allLabels=new ArrayList<>();
	private List<Edge>allEdges=new ArrayList<>();
	private List<Label>nextStateAllLabels=new ArrayList<>();
	

	
	public Node(){}
	
	public Node(int id)
	{
		this.id = id;
	}
	
	public Node(int id,String label)
	{
		this.id=id;
		this.label=label;
	}

	public List<Node> getAllNeighbors()
	{
		return this.allNeighbors;
	}
	public int getId() 
	{
		return this.id;
	}
	public String getLabel()
	{
		return this.label;
	}
	public int getDegree()
	{
		return this.degree;
	}
	public List<Label> getAllLabels()
	{
		return this.allLabels;
	}
	public List<Label> getNextStateAllLabels()
	{
		return this.nextStateAllLabels;
	}
	public List<Edge> getAllEdges()
	{
		return this.allEdges;
	}
	
	public void setId(int id)
	{
		this.id=id;
	}
	public void computeDegree()
	{
		this.degree  = this.getAllNeighbors().size();
	}
	public void setAllLabels(ArrayList<Label> allLabels)
	{
		this.allLabels=allLabels;
	}
	public void setNextStateAllLabels(ArrayList<Label> nextStateAllLabels)
	{
		this.nextStateAllLabels=nextStateAllLabels;
	}
	


}
