package uestc.dm.GILPA_Energy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;



public class Edge
{
    private Node source;
    private Node target;
    private double weight;
    private double similarity;
    
    public Edge(Node source,Node target,double weight)
    {
    	this.source=source;
    	this.target=target;
    	this.weight=weight;
    }
    /**
     * Initialize the edge with respective source id and target id.
     * @param sourceId
     * @param targetId
     * @param nodeSet
     * @param weight
     */
    public Edge(int sourceId,int targetId,List<Node> nodeSet,double weight)
    {
    	for (Node node : nodeSet)
		{
			if(node.getId()==sourceId)
				this.source=node;
			else if(node.getId()==targetId)
				this.target=node;		
		}
    	this.weight=weight;
    }
    
    public Node getSource()
    {
    	return this.source;
    }
    public Node getTarget()
    {
    	return this.target;
    }
    public double getWeight()
    {
    	return this.weight;
    }
    public double getSimilarity()
    {
    	return this.similarity;
    }
    
    @SuppressWarnings("unchecked")
	public void computeSimilarity()
    {
    	List<Node> sourceLambda=new ArrayList<>();
    	List<Node> sourceAllNeighbors=source.getAllNeighbors();
    	for(Node node:sourceAllNeighbors)
    	{
    		sourceLambda.add(node);
    	}
    	sourceLambda.add(source);
    	
    	List<Node> targetLambda=new ArrayList<>();
    	List<Node> targetAllNeighbors=target.getAllNeighbors();
    	for(Node node:targetAllNeighbors)
    	{
    		targetLambda.add(node);
    	}
    	targetLambda.add(target);
    	
    	List<Node> intsct=new ArrayList<>();
		for (Node tempSource : sourceLambda) 
		{
			for (Node tempTarget : targetLambda) 
			{
				if (tempSource.getId() == tempTarget.getId()) 
				{
					intsct.add(tempTarget);
				}

			}
		}
		
		@SuppressWarnings({ "rawtypes" })
		HashSet hashSet = new HashSet(sourceLambda);
		hashSet.addAll(targetLambda);
		@SuppressWarnings({ "rawtypes" })
		List<Node> union=(List<Node>)new ArrayList(hashSet);
		
		this.similarity=(double)intsct.size()/union.size();
//		System.out.println("similarity"+this.similarity);
   	
    }
}
