package uestc.dm.GILPA_Energy;

import java.util.List;

/**
 * Math functions used.
 * @ClassName: Functions
 * @Description: TODO
 * @author Eitima (Zexi Huang)
 * @date 2017425 6:48:00
 * @version 1.0
 */
public class Functions
{
	/**
	 * Tuned F with tuning parameter lambda. Used in interaction scheme.
	 * @param coefficient
	 * @return
	 */
	public static double F(double coefficient)
	{
		double lambda=60;
		return 1/(1+Math.exp(lambda*(0.5-coefficient)));
	}

	
	public static double phi(Community community)
	{
		double result=0;
		List<Node> allNodes=community.getAllNodes();
		for (Node node : allNodes)
		{
			List<Label> allLabels=node.getAllLabels();
			double coefficient = 0;
			for(Label label:allLabels)
			{
				if(label.getCommunity()==community)
					coefficient=label.getCoefficient();
			}
			result=result+Functions.F(coefficient);
		}
		return result;
	}
	public static double psi(Community community)
	{
		double result=0;
		List<Node> allNodes=community.getAllNodes();
		for (Node node : allNodes)
		{
			List<Label> allLabels=node.getAllLabels();
			double coefficient = 0;
			for(Label label:allLabels)
			{
				if(label.getCommunity()==community)
					coefficient=label.getCoefficient();
			}
			result=result+Functions.F(coefficient)*node.getDegree();
		}
		return result;
	}
	public static void renormalize(List<Label> allLabels)
	{
		double sum=0;
		for (Label label : allLabels)
		{
			sum=sum+label.getCoefficient();
		}
		for(Label label:allLabels)
		{
			label.setCoefficient(label.getCoefficient()/sum);
		}
	}
	
	public static double utilityFactor(Node theNode, Label theLabel,int n, int m)
	{
		List<Node> allNeighbors=theNode.getAllNeighbors();
		double sum=0;
		for (Node neighbor : allNeighbors)
		{
			List<Label>labels=neighbor.getAllLabels();
			for (Label label : labels)
			{
				if(theLabel.getCommunity()==label.getCommunity())
					sum=sum+Functions.F(label.getCoefficient());
			}
		}
		return sum-theNode.getDegree()*theLabel.getCommunity().getPhi()*theLabel.getCommunity().getPhi()*
				theLabel.getCommunity().getPsi()/(2*m*n*n);
	}
	/**
	 * The utility q_i(c) is the local Ni modularity for node i and community c.
	 * @param theNode
	 * @param theLabel
	 * @param n
	 * @param m
	 * @return
	 */
	public static double utility(Node theNode, Label theLabel,int n, int m)
	{
		
		double firstTerm=Functions.F(theLabel.getCoefficient());
		double secondTerm=Functions.utilityFactor(theNode, theLabel, n, m);
		
//		System.out.println("firstTerm:"+firstTerm+"\tsecondTerm:"+secondTerm+"\tRatio:"+firstTerm/secondTerm);

		return firstTerm*secondTerm;
	}
	
	
	public static double localModularityE(Node theNode,Label theLabel,int m)
	{
		double firstTerm=0;
		List<Node> allNeighbors=theNode.getAllNeighbors();
		for(Node neighbor:allNeighbors)
		{
			List<Label> allLabels=neighbor.getAllLabels();
			for(Label label:allLabels)
			{
				if(label.getCommunity()==theLabel.getCommunity())
				{
					firstTerm=firstTerm+1.0/theNode.getAllLabels().size()/neighbor.getAllLabels().size();
				}
			}
		}
		double secondTerm=0;
		List<Node> allNodes=theLabel.getCommunity().getAllNodes();
		for(Node node:allNodes)
		{
			secondTerm=secondTerm+1.0*node.getDegree()/node.getAllLabels().size();
		}
		secondTerm=secondTerm*theNode.getDegree()/2/m/theNode.getAllLabels().size();
		
		return firstTerm-secondTerm;
		
	}
	public static double totalUtility(List<Label> allLabels,Node node,int n, int m)
	{
		double result=0;
		for(Label label:allLabels)
		{
			result=result+Functions.utility(node, label, n, m);
		}
		return result;
	}
	public static double computeModularityE(List<Node> nodeSet, int m)
	{
		double modularityE=0;
		for(Node node:nodeSet)
		{
			List<Label> allLabels=node.getAllLabels();
			for(Label label:allLabels)
			{
				modularityE=modularityE+Functions.localModularityE(node, label, m);
			}
		}
		
		modularityE=modularityE/2/m;
		
		
		return modularityE;
	}
	
	public static int numberOfLabels(List<Node> nodeSet)
	{
		int numberOfLabels=0;
		for (Node node : nodeSet)
		{
			numberOfLabels=numberOfLabels+node.getAllLabels().size();
		}
		return numberOfLabels;
	}
	
	
	/**
	 * Compute the Ni modularity for this clustering.
	 * @return
	 */
	public static double computeModularityNi(List<Node> nodeSet,int n, int m)
	{
		double modularityNi=0;
		
		for(Node node:nodeSet)
		{
			List<Label> allLabels=node.getAllLabels();
			for(Label label:allLabels)
			{
				modularityNi=modularityNi+Functions.utilityForModularity(node, label, n, m);
			}
			
		}
		
		modularityNi=modularityNi/(2*m);
		return modularityNi;
	}
	public static double utilityForModularity(Node theNode, Label theLabel,int n, int m)
	{
		
		double firstTerm=Functions.FForModularity(theLabel.getCoefficient());
		double secondTerm=Functions.utilityFactorForModularity(theNode, theLabel, n, m);
		return firstTerm*secondTerm;
	}
	public static double utilityFactorForModularity(Node theNode, Label theLabel,int n, int m)
	{
		List<Node> allNeighbors=theNode.getAllNeighbors();
		double sum=0;
		for (Node neighbor : allNeighbors)
		{
			List<Label>labels=neighbor.getAllLabels();
			for (Label label : labels)
			{
				if(theLabel.getCommunity()==label.getCommunity())
					sum=sum+Functions.FForModularity(label.getCoefficient());
			}
		}
		return sum-theNode.getDegree()*theLabel.getCommunity().getPhiForModularity()*theLabel.getCommunity().getPhiForModularity()*
				theLabel.getCommunity().getPsiForModularity()/(2.0*m*n*n);
	}
	public static double phiForModularity(Community community)
	{
		double result=0;
		List<Node> allNodes=community.getAllNodes();
		for (Node node : allNodes)
		{
			List<Label> allLabels=node.getAllLabels();
			double coefficient = 0;
			for(Label label:allLabels)
			{
				if(label.getCommunity()==community)
					coefficient=label.getCoefficient();
			}
			result=result+Functions.FForModularity(coefficient);
		}
		return result;
	}
	public static double psiForModularity(Community community)
	{
		double result=0;
		List<Node> allNodes=community.getAllNodes();
		for (Node node : allNodes)
		{
			List<Label> allLabels=node.getAllLabels();
			double coefficient = 0;
			for(Label label:allLabels)
			{
				if(label.getCommunity()==community)
					coefficient=label.getCoefficient();
			}
			result=result+Functions.FForModularity(coefficient)*node.getDegree();
		}
		return result;
	}
	/**
	 * Fixed F with lambda=60. Used to computer global modularity.
	 * @param coefficient
	 * @return
	 */
	public static double FForModularity(double coefficient)
	{
		return 1/(1+Math.exp(30-60*coefficient));
	}
}
