package uestc.dm.GILPA_Energy;

public class LabelWithCost implements Comparable<LabelWithCost>
{
	
	private Label label;
	private double cost;
	
	public LabelWithCost(Label label, double cost)
	{
		this.label=label;
		this.cost=cost;
	}
	
	public Label getLabel()
	{
		return this.label;
	}
	public double getCost()
	{
		return this.cost;
	}
	public void setLabel(Label label)
	{
		this.label=label;
	}
	public void setCost(double cost)
	{
		this.cost=cost;
	}

	@Override
	/**
	 * Since we compare the cost and Collections.sort() sorts the sequence into ascending order,
	 * we don't need to reverse the comparator
	 */
	public int compareTo(LabelWithCost o)
	{
		if(this.cost>o.cost)
			return 1;
		else if(this.cost<o.cost)
			return -1;
		else return 0;
	}
	

}
