package uestc.dm.GILPA;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.html.HTMLIsIndexElement;

public class Community implements Comparable<Community>
{
	private int id;
	private double phi;
	private double psi;
	private List<Node> allNodes=new ArrayList<>();
	private List<Node> nextStateAllNodes=new ArrayList<>();
	
	private double phiForModularity;
	private double psiForModularity;
	
	public Community(int id)
	{
		this.id=id;
	}
	public Community(int id,List<Node> allNodes)
	{
		this.id=id;
		this.allNodes=allNodes;
	}
	public Community(){}
	
	public int getId()
	{
		return this.id;
	}
	public double getPhi()
	{
		return this.phi;
	}
	public double getPsi()
	{
		return this.psi;
	}
	public List<Node> getAllNodes()
	{
		return this.allNodes;
	}
	public List<Node> getNextStateAllNodes()
	{
		return this.nextStateAllNodes;
	}
	
	public double getPhiForModularity()
	{
		return this.phiForModularity;
	}
	public double getPsiForModularity()
	{
		return this.psiForModularity;
	}
	
	/**
	 *Update value of phi based on current nodes in this community. 
	 */
	public void updatePhi()
	{
		this.phi=Functions.phi(this);
		
		this.phiForModularity=Functions.phiForModularity(this);
	}
	/**
	 *Update value of psi based on current nodes in this community. 
	 */
	public void updatePsi()
	{
		this.psi=Functions.psi(this);
		
		this.psiForModularity=Functions.psiForModularity(this);
	}
	/**
	 * If the community has bigger size than the other, than it is considered bigger.
	 * However, since we want the community to be sorted into descending order instead of ascending, we reverse this result.
	 * @param o
	 * @return
	 */
	@Override
	public int compareTo(Community o)
	{
		return -(this.getAllNodes().size()-o.getAllNodes().size());
	}
	
	public boolean isSubsetOf(Community o)
	{
		return o.getAllNodes().containsAll(this.getAllNodes());
	}
	
	

}
