package uestc.dm.GILPA;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class LabelDroppingTechniques
{
	public static void dropNegativeUtilityFactor(List<Label> nextStateAllLabels,Node node,int n,int m)
	{
		List<Label> toBeDelectedLabels=new ArrayList<>();

		
		for(Label label:nextStateAllLabels)
		{

			
			if(Functions.utility(node, label, n, m)<0)

				
			{
				toBeDelectedLabels.add(label);
			}
		}
		
		
		if(!toBeDelectedLabels.isEmpty())
			System.out.print("a");	
		
		
		HashSet<Label> sub = new HashSet<>(nextStateAllLabels);
		sub.removeAll(toBeDelectedLabels);
		List<Label> remainingLabels=new ArrayList<Label>(sub);
		
		nextStateAllLabels.clear();
		
		
		for(Label label:remainingLabels)
		{
			nextStateAllLabels.add(label);
			//Add the node in communities for next state.
			label.getCommunity().getNextStateAllNodes().add(node);
		}
		remainingLabels.clear();
	}
	
	public static void dropNegativeLocalModularityE(List<Label> nextStateAllLabels,Node node,int m)
	{
		List<Label> toBeDelectedLabels=new ArrayList<>();

		
		for(Label label:nextStateAllLabels)
		{

			

		if(Functions.localModularityE(node, label, m)<0)
				
			{
				toBeDelectedLabels.add(label);
			}
		}
		
		
		if(!toBeDelectedLabels.isEmpty())
			System.out.print("a");	
		
		
		HashSet<Label> sub = new HashSet<>(nextStateAllLabels);
		sub.removeAll(toBeDelectedLabels);
		List<Label> remainingLabels=new ArrayList<Label>(sub);
		
		nextStateAllLabels.clear();
		
		
		for(Label label:remainingLabels)
		{
			nextStateAllLabels.add(label);
			//Add the node in communities for next state.
			label.getCommunity().getNextStateAllNodes().add(node);
		}
		remainingLabels.clear();
	}
	
	public static void keepMaximalUtilityOnly(List<Label> nextStateAllLabels,Node node,int n, int m)
	{
		Label maximalLabel=new Label();
		double maximalUtilityFactor=Double.NEGATIVE_INFINITY;
		for(Label label:nextStateAllLabels)
		{
			if(Functions.utility(node, label, n, m)>maximalUtilityFactor)
			{
				maximalLabel=label;
				maximalUtilityFactor=Functions.utility(node, label, n, m);
			}
		}
		nextStateAllLabels.clear();
		nextStateAllLabels.add(maximalLabel);
	}
	public static void keepMaximalModularityEOnly(List<Label> nextStateAllLabels,Node node, int m)
	{
		Label maximalLabel=new Label();
		double maximalModularityE=Double.NEGATIVE_INFINITY;
		for(Label label:nextStateAllLabels)
		{
			if(Functions.localModularityE(node, label, m)>maximalModularityE)
			{
				maximalLabel=label;
				maximalModularityE=Functions.localModularityE(node, label, m);
			}
		}
		nextStateAllLabels.clear();
		nextStateAllLabels.add(maximalLabel);
	}
	
	public static void keepMaximalUtilityAndModularityE(List<Label> nextStateAllLabels,Node node,int n, int m)
	{
		Label maximalUtilityLabel=new Label();
		double maximalUtilityFactor=Double.NEGATIVE_INFINITY;
		for(Label label:nextStateAllLabels)
		{
			if(Functions.utility(node, label, n, m)>maximalUtilityFactor)
			{
				maximalUtilityLabel=label;
				maximalUtilityFactor=Functions.utility(node, label, n, m);
			}
		}
		
		Label maximalModularityELabel=new Label();
		double maximalModularityE=Double.NEGATIVE_INFINITY;
		for(Label label:nextStateAllLabels)
		{
			if(Functions.localModularityE(node, label, m)>maximalModularityE)
			{
				maximalModularityELabel=label;
				maximalModularityE=Functions.localModularityE(node, label, m);
			}
		}
		
		nextStateAllLabels.clear();
		
		if(maximalModularityELabel==maximalUtilityLabel)
		{
			nextStateAllLabels.add(maximalUtilityLabel);
//			System.out.println("Equal.");
		}
		else
		{
			nextStateAllLabels.add(maximalModularityELabel);
			nextStateAllLabels.add(maximalUtilityLabel);
		}
		
	}
	
	public static void keepMaximalUtilityFactorOnly(List<Label> nextStateAllLabels,Node node,int n, int m)
	{
		Label maximalLabel=new Label();
		double maximalUtilityFactor=Double.NEGATIVE_INFINITY;
		for(Label label:nextStateAllLabels)
		{
			if(Functions.utilityFactor(node, label, n, m)>maximalUtilityFactor)
			{
				maximalLabel=label;
				maximalUtilityFactor=Functions.utility(node, label, n, m);
			}
		}
		nextStateAllLabels.clear();
		nextStateAllLabels.add(maximalLabel);
	}
	
	public static void dropAsCOPRA(List<Label> nextStateAllLabels,Node node,double maximalLabels)
	{		
		Iterator<Label> iterator=nextStateAllLabels.iterator();
		double maxCoefficient=0;
		Community maxCommunity=new Community();
		while (iterator.hasNext())
		{
			Label label = (Label) iterator.next();
			double coefficient=label.getCoefficient();
			Community community=label.getCommunity();
			if(coefficient<1/maximalLabels)
			{
				iterator.remove();
				if(coefficient>maxCoefficient)
				{
					maxCoefficient=coefficient;
					maxCommunity=community;
				}
			}		
		}
		if(nextStateAllLabels.isEmpty())
		{
			nextStateAllLabels.add(new Label(maxCommunity, maxCoefficient));
		}
	}
	public static void greedilyDropLabelWithLowestUtility(List<Label> nextStateAllLabels,Node node,int n, int m)
	{
		boolean utilityIncreased=true;
		
		List<Label> labelsAfterDeleting=new ArrayList<>();
		for(Label label:nextStateAllLabels)
		{
			labelsAfterDeleting.add(label);
		}
		double totalUtiliy=Functions.totalUtility(nextStateAllLabels,node, n, m);
		double totalUtilityAfterDeleting;
		
		while(utilityIncreased)
		{
			double minimalUtility=Double.POSITIVE_INFINITY;
			Label minimalLabel=new Label();
			for(Label label:nextStateAllLabels)
			{
				if(Functions.utility(node, label, n, m)<minimalUtility)
				{
					minimalUtility=Functions.utility(node, label, n, m);
					minimalLabel=label;
				}
			}
			
			labelsAfterDeleting.remove(minimalLabel);
			Functions.renormalize(labelsAfterDeleting);
			totalUtilityAfterDeleting=Functions.totalUtility(labelsAfterDeleting, node, n, m);
			if(totalUtilityAfterDeleting>totalUtiliy)
			{
				nextStateAllLabels.remove(minimalLabel);
				Functions.renormalize(nextStateAllLabels);
				totalUtiliy=totalUtilityAfterDeleting;
			}
			else
			{
				utilityIncreased=false;
				labelsAfterDeleting.clear();
			}
			
			
		}
	}
	public static void greedilyDropLabelWithLowestUtilitySmallerThanThreshold(List<Label> nextStateAllLabels,Node node,int n, int m,double threshold)
	{
		
		while(nextStateAllLabels.size()>1)
		{
			double minimalUtility=Double.POSITIVE_INFINITY;
			Label minimalLabel=new Label();
			for(Label label:nextStateAllLabels)
			{
				if(Functions.utility(node, label, n, m)<minimalUtility)
				{
					minimalUtility=Functions.utility(node, label, n, m);
					minimalLabel=label;
				}
			}
			if(Functions.utility(node, minimalLabel, n, m)<threshold)
			{
				nextStateAllLabels.remove(minimalLabel);
				Functions.renormalize(nextStateAllLabels);
			}
			else
			{
				break;
			}

			
			
		}
//		if(nextStateAllLabels.size()!=1)
//		{
//			System.out.println("Yeah");
//		}
	}
	
	public static void greedilyDropLabelWithLowestUtilityFactorSmallerThanThreshold(List<Label> nextStateAllLabels,Node node,int n, int m,double threshold)
	{
		
		while(nextStateAllLabels.size()>1)
		{
			double minimalUtilityFactor=Double.POSITIVE_INFINITY;
			Label minimalLabel=new Label();
			for(Label label:nextStateAllLabels)
			{
				if(Functions.utilityFactor(node, label, n, m)<minimalUtilityFactor)
				{
					minimalUtilityFactor=Functions.utilityFactor(node, label, n, m);
					minimalLabel=label;
				}
			}
			if(Functions.utilityFactor(node, minimalLabel, n, m)<threshold)
			{
				nextStateAllLabels.remove(minimalLabel);
				Functions.renormalize(nextStateAllLabels);
			}
			else
			{
				break;
			}
		}
//		if(nextStateAllLabels.size()!=1)
//		{
//			System.out.println("Yeah");
//		}
	}

	

}
