/*
 * Decompiled with CFR 0.152.
 */
package com.xtremeprog.xpgconnect;

import android.content.Context;
import android.util.Log;
import com.xtremeprog.xpgconnect.smartlink.OnSmartLinkListener;
import com.xtremeprog.xpgconnect.smartlink.SmartLinkedModule;
import com.xtremeprog.xpgconnect.smartlink.v3.SnifferSmartLinker;

public class HFSnifferSmartLinker
implements OnSmartLinkListener {
    private static final String TAG = "HFSnifferSmartLinkerManager";
    private static SnifferSmartLinker mSnifferSmartLinker;
    private static HFSnifferSmartLinker mHFSnifferSmartLinker;
    private boolean mIsRunning = false;

    static {
        mHFSnifferSmartLinker = new HFSnifferSmartLinker();
    }

    public static HFSnifferSmartLinker sharedInstance() {
        mSnifferSmartLinker = SnifferSmartLinker.getInstence();
        return mHFSnifferSmartLinker;
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public void start(String ssid, String password, int timeout, Context context) {
        Log.w((String)TAG, (String)("start config: ssid = " + ssid + ", password = " + password));
        if (!this.mIsRunning) {
            try {
                mSnifferSmartLinker.start(context, password, ssid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mIsRunning = true;
        }
    }

    public void stop() {
        mSnifferSmartLinker.setOnSmartLinkListener(null);
        mSnifferSmartLinker.stop();
        this.mIsRunning = false;
    }

    @Override
    public void onLinked(SmartLinkedModule module) {
        Log.w((String)TAG, (String)("onLinked hiflying_smartlinker_new_module_found: " + module.getMac() + ", " + module.getModuleIP()));
    }

    @Override
    public void onCompleted() {
        Log.w((String)TAG, (String)"onCompleted hiflying_smartlinker_completed");
        this.mIsRunning = false;
    }

    @Override
    public void onTimeOut() {
        Log.w((String)TAG, (String)"onTimeOut hiflying_smartlinker_timeout");
        this.mIsRunning = false;
    }
}

