/*
 * Decompiled with CFR 0.152.
 */
package com.xtremeprog.xpgconnect;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.util.Log;
import com.xtremeprog.xpgconnect.GizLogger;

class NetStatusReceiver
extends BroadcastReceiver {
    static final String TAG = "NetStatus";
    static final String Net2G = "2G";
    static final String Net3G = "3G";
    static final String Net4G = "4G";
    static final String FreeWIFI = "LAN";
    static final String PublicWIFI = "WLAN";
    static final String NetDisable = "NetDisable";
    static final String CMCC = "CMCC";
    static final String ChinaNet = "ChinaNet";
    static final String ChinaUnicom = "ChinaUnicom";

    NetStatusReceiver() {
    }

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
            String ssidInfo = null;
            String networkType = this.GetNetworkType(context);
            if (networkType.equals(PublicWIFI) || networkType.equals(FreeWIFI)) {
                ssidInfo = "ssid = " + NetStatusReceiver.getCurentWifiSSID(context);
            }
            GizLogger.b("net_type_switch", networkType, ssidInfo);
        }
    }

    protected static String getCurentWifiSSID(Context context) {
        String ssid = "";
        if (context != null) {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            ssid = wifiInfo.getSSID();
            int deviceVersion = Build.VERSION.SDK_INT;
            if (deviceVersion >= 17 && ssid.startsWith("\"") && ssid.endsWith("\"")) {
                ssid = ssid.substring(1, ssid.length() - 1);
            }
        } else {
            Log.e((String)"XPGWifiSDK", (String)"cann't get current ssid, the context is null. Please startWithAppID first!");
        }
        return ssid;
    }

    private String GetNetworkType(Context context) {
        if (context == null) {
            GizLogger.d(TAG, "context is null");
            return NetDisable;
        }
        ConnectivityManager connectManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            GizLogger.d(TAG, "can not get active network info");
            return NetDisable;
        }
        networkInfo = connectManager.getNetworkInfo(1);
        if (networkInfo.isConnected()) {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            if (wifiInfo != null && (wifiInfo.getSSID().equals(CMCC) || wifiInfo.getSSID().equals(ChinaNet) || wifiInfo.getSSID().equals(ChinaUnicom))) {
                GizLogger.d(TAG, "wifi ssid is mobile public wifi");
                return PublicWIFI;
            }
            return FreeWIFI;
        }
        String type = NetDisable;
        networkInfo = connectManager.getNetworkInfo(0);
        if (networkInfo.isConnected()) {
            String _strSubTypeName = networkInfo.getSubtypeName();
            int mobileType = networkInfo.getSubtype();
            switch (mobileType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    type = Net2G;
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    type = Net3G;
                    break;
                }
                case 13: {
                    type = Net4G;
                    break;
                }
                default: {
                    if (_strSubTypeName.equalsIgnoreCase("TD-SCDMA") || _strSubTypeName.equalsIgnoreCase("WCDMA") || _strSubTypeName.equalsIgnoreCase("CDMA2000")) {
                        type = Net3G;
                        break;
                    }
                    type = _strSubTypeName;
                    break;
                }
            }
        } else {
            GizLogger.d(TAG, "no any mobile network is connected");
        }
        return type;
    }
}

