/*
 * Decompiled with CFR 0.152.
 */
package com.xtremeprog.xpgconnect;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.realtek.simpleconfiglib.SCLibrary;

class RTKSimpleConfigManager {
    private String TAG = "RTKSimpleConfig";
    private static RTKSimpleConfigManager mRTKSimpleConfig;
    private SCLibrary SCLib = new SCLibrary();
    private boolean TimesupFlag_cfg = true;
    private Context mContext;
    private String ssid;
    private String key;
    private static final int stopConfig = 0;
    private int configTimeout;

    static {
        System.loadLibrary("simpleconfiglib");
        mRTKSimpleConfig = new RTKSimpleConfigManager();
    }

    private RTKSimpleConfigManager() {
    }

    public static RTKSimpleConfigManager sharedInstance() {
        return mRTKSimpleConfig;
    }

    protected void stopRTKSimpleConfig() {
        Message msg = Message.obtain();
        msg.obj = null;
        msg.what = 0;
        RTKSimpleConfigManager.sharedInstance().sendMessage(msg);
    }

    @Deprecated
    protected SCLibrary getSCLib() {
        return this.SCLib;
    }

    @Deprecated
    protected String initSCLib(Context context, Handler handler) {
        this.SCLib.rtk_sc_init();
        this.SCLib.TreadMsgHandler = handler;
        this.SCLib.WifiInit(context);
        return this.SCLib.WifiGetMacStr();
    }

    protected void sendMessage(Message msg) {
        this.SCLib.TreadMsgHandler.sendMessage(msg);
    }

    protected void startRTKSimpleConfig(String ssid, String key, String pinCode, int timeout, Context context) {
        this.mContext = context;
        this.ssid = ssid;
        this.key = key;
        this.configTimeout = timeout * 1000;
        this.SCLib.rtk_sc_init();
        this.SCLib.TreadMsgHandler = new MsgHandler();
        this.SCLib.WifiInit(this.mContext);
        Thread ConfigDeviceThread = new Thread(){

            @Override
            public void run() {
                RTKSimpleConfigManager.this.Configure_action();
            }
        };
        ConfigDeviceThread.start();
    }

    private void Configure_action() {
        int stepOneTimeout = 30000;
        int connect_count = 200;
        int wifiIP = this.SCLib.WifiGetIpInt();
        while (connect_count > 0 && wifiIP == 0) {
            wifiIP = this.SCLib.WifiGetIpInt();
            --connect_count;
        }
        if (wifiIP == 0) {
            Log.e((String)this.TAG, (String)"Allocating IP is 0, cannot running simple config");
            return;
        }
        this.SCLib.rtk_sc_reset();
        this.SCLib.rtk_sc_set_default_pin("");
        this.SCLib.rtk_sc_set_pin(null);
        this.SCLib.rtk_sc_set_ssid(this.ssid);
        this.SCLib.rtk_sc_set_password(this.key);
        this.TimesupFlag_cfg = false;
        this.SCLib.rtk_sc_set_ip(wifiIP);
        this.SCLib.rtk_sc_build_profile();
        SCLibrary.ProfileSendTimeMillis = this.configTimeout;
        SCLibrary.ProfileSendTimeIntervalMs = 50;
        SCLibrary.PacketSendTimeIntervalMs = 0;
        SCLibrary.EachPacketSendCounts = 1;
        if (Build.MANUFACTURER.equalsIgnoreCase("Samsung")) {
            if (Build.MODEL.equalsIgnoreCase("G9008")) {
                SCLibrary.PacketSendTimeIntervalMs = 10;
            } else if (Build.MODEL.contains("N900")) {
                SCLibrary.PacketSendTimeIntervalMs = 5;
            } else if (Build.MODEL.contains("SM-N910U")) {
                SCLibrary.PacketSendTimeIntervalMs = 5;
            }
        }
        this.SCLib.rtk_sc_start();
        int watchCount = 0;
        try {
            do {
                Thread.sleep(1000L);
            } while (!this.TimesupFlag_cfg && (watchCount += 1000) < stepOneTimeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (!this.TimesupFlag_cfg) {
            int count = 0;
            SCLibrary.ProfileSendTimeIntervalMs = 100;
            SCLibrary.PacketSendTimeIntervalMs = 3;
            SCLibrary.EachPacketSendCounts = 2;
            if (Build.MANUFACTURER.equalsIgnoreCase("Samsung")) {
                if (Build.MODEL.equalsIgnoreCase("G9008")) {
                    SCLibrary.PacketSendTimeIntervalMs = 10;
                } else if (Build.MODEL.contains("N900")) {
                    SCLibrary.PacketSendTimeIntervalMs = 5;
                } else if (Build.MODEL.contains("SM-N910U")) {
                    SCLibrary.PacketSendTimeIntervalMs = 5;
                }
            }
            try {
                do {
                    Thread.sleep(1000L);
                } while ((this.configTimeout - stepOneTimeout) / 1000 - ++count >= 0 && !this.TimesupFlag_cfg);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.TimesupFlag_cfg = true;
            this.SCLib.rtk_sc_stop();
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class MsgHandler
    extends Handler {
        private MsgHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    Log.d((String)"MsgHandler", (String)"Config stop");
                    RTKSimpleConfigManager.this.SCLib.rtk_sc_stop();
                    RTKSimpleConfigManager.this.TimesupFlag_cfg = true;
                }
            }
        }
    }
}

