/*
 * Decompiled with CFR 0.152.
 */
package com.xtremeprog.xpgconnect;

import com.xtremeprog.xpgconnect.GWifiDevice;
import com.xtremeprog.xpgconnect.GWifiDeviceList;
import com.xtremeprog.xpgconnect.GWifiDeviceListener;
import com.xtremeprog.xpgconnect.GWifiDeviceType;
import com.xtremeprog.xpgconnect.GWifiErrorCode;
import com.xtremeprog.xpgconnect.GWifiQueryHardwareInfoStruct;
import com.xtremeprog.xpgconnect.GizLogger;
import com.xtremeprog.xpgconnect.Vector_GWifiReceiveInfo;
import com.xtremeprog.xpgconnect.XPGWifiCentralControlDeviceListener;
import com.xtremeprog.xpgconnect.XPGWifiDeviceListener;
import com.xtremeprog.xpgconnect.XPGWifiSubDevice;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class XPGWifiDevice {
    private static final String TAG = "XPGWifiDevice";
    private XPGWifiDevice device;
    private GWifiDevice originDevice;
    private XPGWifiDevice configDevice;
    private GWifiDevice originConfigDevice;
    protected XPGWifiDeviceListener mListener;
    public static String XPGWifiDeviceLogLevelKey = "level";
    public static String XPGWifiDeviceLogTagKey = "tag";
    public static String XPGWifiDeviceLogSourceKey = "source";
    public static String XPGWifiDeviceLogContentKey = "content";
    public static String XPGWifiDeviceLogBinaryKey = "binary";
    public static String XPGWifiDeviceLogTimeKey = "time";
    public static String XPGWifiDeviceHardwareWifiHardVerKey = "wifiHardVer";
    public static String XPGWifiDeviceHardwareWifiSoftVerKey = "wifiSoftVer";
    public static String XPGWifiDeviceHardwareMCUHardVerKey = "mcuHardVer";
    public static String XPGWifiDeviceHardwareMCUSoftVerKey = "mcuSoftVer";
    public static String XPGWifiDeviceHardwareFirmwareIdKey = "firmwareId";
    public static String XPGWifiDeviceHardwareFirmwareVerKey = "firmwareVer";
    public static String XPGWifiDeviceHardwareProductKey = "productKey";
    private GWifiDeviceListener listener = new GWifiDeviceListener(){

        @Override
        public void onDisconnected() {
            if (XPGWifiDevice.this.device.isLAN()) {
                GizLogger.b("l_disconnect_result", "result = 0", "LAN device disconnect result: mac = " + XPGWifiDevice.this.device.getMacAddress());
            } else {
                GizLogger.b("m_disconnect_result", "result = 0", "MQTT device disconnect result: mac = " + XPGWifiDevice.this.device.getMacAddress());
            }
            if (XPGWifiDevice.this.mListener != null) {
                GizLogger.d(XPGWifiDevice.TAG, "Success callback didDisconnected, XPGWifiDeviceListener = " + XPGWifiDevice.this.mListener + ", " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress());
                XPGWifiDevice.this.mListener.didDisconnected(XPGWifiDevice.this.device, 0);
                XPGWifiDevice.this.mListener.didDisconnected(XPGWifiDevice.this.device);
                GizLogger.d("XPGWifiSDK", "didDisconnected callback come back\uff0cYeah\uff01");
            } else {
                GizLogger.d(XPGWifiDevice.TAG, "Success callback didDisconnected, XPGWifiDeviceListener = null, " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress());
            }
        }

        @Override
        public void onLogin(int result) {
            if (XPGWifiDevice.this.device.isLAN()) {
                GizLogger.b("l_login_resp", "result = " + result, "LAN device login result: mac = " + XPGWifiDevice.this.device.getMacAddress());
            } else {
                GizLogger.b("m_login_resp", "result = " + result, "MQTT device login result: mac = " + XPGWifiDevice.this.device.getMacAddress());
            }
            if (XPGWifiDevice.this.mListener != null) {
                GizLogger.d(XPGWifiDevice.TAG, "Success callback didLogin, result = " + result + ", XPGWifiDeviceListener = " + XPGWifiDevice.this.mListener + ", " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress());
                XPGWifiDevice.this.mListener.didLogin(XPGWifiDevice.this.device, result);
                GizLogger.d("XPGWifiSDK", "didLogin callback come back\uff0cYeah\uff01");
            } else {
                GizLogger.d(XPGWifiDevice.TAG, "Success callback didLogin, XPGWifiDeviceListener = null, " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress());
            }
        }

        @Override
        public boolean onReceiveData(String data, Vector_GWifiReceiveInfo alerts, Vector_GWifiReceiveInfo faults, byte[] binary, int result) {
            if (result > 0) {
                result -= 256;
            }
            if (XPGWifiDevice.this.device.isLAN()) {
                GizLogger.b("l_status_report", "result = " + result, "LAN device status report: mac = " + XPGWifiDevice.this.device.getMacAddress());
            } else {
                GizLogger.b("m_status_report", "result = " + result, "MQTT device status report: mac = " + XPGWifiDevice.this.device.getMacAddress());
            }
            if (XPGWifiDevice.this.mListener != null) {
                GizLogger.d(XPGWifiDevice.TAG, "Success callback didReceiveData, result = " + result + ", XPGWifiDeviceListener = " + XPGWifiDevice.this.mListener + ", " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress());
                ConcurrentHashMap<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
                if (data != null) {
                    dataMap.put("data", data);
                }
                GizLogger.d(XPGWifiDevice.TAG, "result = " + result + ", binary = " + binary);
                if (binary != null && result == GWifiErrorCode.GWifiError_RAW_DATA_TRANSMIT.swigValue()) {
                    dataMap.put("binary", binary);
                }
                JSONObject jsonAlerts = new JSONObject();
                JSONObject jsonFaults = new JSONObject();
                try {
                    int i = 0;
                    while ((long)i < alerts.size()) {
                        GizLogger.d(XPGWifiDevice.TAG, String.valueOf(alerts.get(i).getName()) + ", " + alerts.get(i).getValue());
                        jsonAlerts.put(alerts.get(i).getName(), alerts.get(i).getValue());
                        ++i;
                    }
                    if (alerts.size() > 0L) {
                        dataMap.put("alters", jsonAlerts.toString());
                    }
                    i = 0;
                    while ((long)i < faults.size()) {
                        GizLogger.d(XPGWifiDevice.TAG, String.valueOf(faults.get(i).getName()) + ", " + faults.get(i).getValue());
                        jsonFaults.put(faults.get(i).getName(), faults.get(i).getValue());
                        ++i;
                    }
                    if (faults.size() > 0L) {
                        dataMap.put("faults", jsonFaults.toString());
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                XPGWifiDevice.this.mListener.didReceiveData(XPGWifiDevice.this.device, dataMap, result);
                GizLogger.d(XPGWifiDevice.TAG, "didReceiveData callback come back\uff0cYeah\uff01");
            } else {
                GizLogger.d(XPGWifiDevice.TAG, "Success callback didReceiveData, XPGWifiDeviceListener = null, " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress());
            }
            return true;
        }

        @Override
        public void onReceiveAlertsAndFaultsInfo(Vector_GWifiReceiveInfo alerts, Vector_GWifiReceiveInfo faults, byte[] binary) {
            if (XPGWifiDevice.this.device.isLAN()) {
                GizLogger.b("l_status_report", "result = 0", "LAN device status report: mac = " + XPGWifiDevice.this.device.getMacAddress());
            } else {
                GizLogger.b("m_status_report", "result = 0", "MQTT device status report: mac = " + XPGWifiDevice.this.device.getMacAddress());
            }
            if (XPGWifiDevice.this.mListener != null) {
                GizLogger.d(XPGWifiDevice.TAG, "Success callback didReceiveData, result = 0, XPGWifiDeviceListener = " + XPGWifiDevice.this.mListener + ", " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress());
                ConcurrentHashMap<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
                JSONObject jsonAlerts = new JSONObject();
                JSONObject jsonFaults = new JSONObject();
                try {
                    int i = 0;
                    while ((long)i < alerts.size()) {
                        GizLogger.d(alerts.get(i).getName(), String.valueOf(alerts.get(i).getValue()));
                        jsonAlerts.put(alerts.get(i).getName(), alerts.get(i).getValue());
                        ++i;
                    }
                    if (alerts.size() > 0L) {
                        dataMap.put("alters", jsonAlerts.toString());
                    }
                    i = 0;
                    while ((long)i < faults.size()) {
                        GizLogger.d(XPGWifiDevice.TAG, String.valueOf(faults.get(i).getName()) + ", " + faults.get(i).getValue());
                        jsonFaults.put(faults.get(i).getName(), faults.get(i).getValue());
                        ++i;
                    }
                    if (faults.size() > 0L) {
                        dataMap.put("faults", jsonFaults.toString());
                    }
                    if (binary != null) {
                        dataMap.put("binary", binary);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                XPGWifiDevice.this.mListener.didReceiveData(XPGWifiDevice.this.device, dataMap, 0);
                GizLogger.d(XPGWifiDevice.TAG, "didReceiveData callback come back\uff0cYeah\uff01");
            } else {
                GizLogger.d(XPGWifiDevice.TAG, "Success callback didReceiveData, XPGWifiDeviceListener = null, " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress());
            }
        }

        @Override
        public void onDeviceOnline(boolean isOnline) {
            if (XPGWifiDevice.this.device.isLAN()) {
                GizLogger.b("l_offline_report", "result = 0", "LAN device offline: " + isOnline + ", mac = " + XPGWifiDevice.this.device.getMacAddress());
            } else {
                GizLogger.b("m_offline_report", "result = 0", "MQTT device offline: " + isOnline + ", mac = " + XPGWifiDevice.this.device.getMacAddress());
            }
            if (XPGWifiDevice.this.mListener != null) {
                GizLogger.d(XPGWifiDevice.TAG, "Success callback didDeviceOnline, isOnline = " + isOnline + ", XPGWifiDeviceListener = " + XPGWifiDevice.this.mListener + ", " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress());
                XPGWifiDevice.this.mListener.didDeviceOnline(XPGWifiDevice.this.device, isOnline);
                GizLogger.d(XPGWifiDevice.TAG, "didDeviceOnline callback come back\uff0cYeah\uff01");
            } else {
                GizLogger.d(XPGWifiDevice.TAG, "Success callback didDeviceOnline, XPGWifiDeviceListener = null, " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress());
            }
        }

        @Override
        public void onSetSwitcher(int result) {
            GizLogger.d(XPGWifiDevice.TAG, "Success callback " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress() + " didSetSwitcher, XPGWifiDeviceListener " + (XPGWifiDevice.this.mListener == null ? "= null" : XPGWifiDevice.this.mListener));
            if (XPGWifiDevice.this.mListener != null) {
                XPGWifiDevice.this.mListener.didSetSwitcher(XPGWifiDevice.this.device, result);
            }
        }

        @Override
        public void onDeviceLog(short nLevel, String tag, String source, String content, String logdata, int logdatalen, String timec) {
            GizLogger.d(XPGWifiDevice.TAG, "Success callback " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress() + " didUpdateDeviceLog, XPGWifiDeviceListener " + (XPGWifiDevice.this.mListener == null ? "= null" : XPGWifiDevice.this.mListener));
            if (XPGWifiDevice.this.mListener != null) {
                ConcurrentHashMap<String, Object> logInfo = new ConcurrentHashMap<String, Object>();
                logInfo.put(XPGWifiDeviceLogLevelKey, String.valueOf(nLevel));
                logInfo.put(XPGWifiDeviceLogTagKey, tag);
                logInfo.put(XPGWifiDeviceLogSourceKey, source);
                logInfo.put(XPGWifiDeviceLogContentKey, content);
                logInfo.put(XPGWifiDeviceLogTimeKey, timec);
                XPGWifiDevice.this.mListener.didUpdateDeviceLog(XPGWifiDevice.this.device, logInfo);
            }
        }

        @Override
        public void onQueryHardwareInfo(int error, GWifiQueryHardwareInfoStruct pInfo) {
            if (XPGWifiDevice.this.device.isLAN()) {
                GizLogger.b("l_get_hardware_info_resp", "result = " + error, "LAN device get hw info result: mac = " + XPGWifiDevice.this.device.getMacAddress());
            } else {
                GizLogger.b("m_get_hardware_info_resp", "result = " + error, "MQTT device get hw info result: mac = " + XPGWifiDevice.this.device.getMacAddress());
            }
            if (XPGWifiDevice.this.mListener != null) {
                GizLogger.d(XPGWifiDevice.TAG, "Success callback didQueryHardwareInfo, error = " + error + ", XPGWifiDeviceListener = " + XPGWifiDevice.this.mListener + ", " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress());
                ConcurrentHashMap<String, String> hardwareInfo = new ConcurrentHashMap<String, String>();
                hardwareInfo.put(XPGWifiDeviceHardwareFirmwareIdKey, pInfo.getFirmwareId());
                hardwareInfo.put(XPGWifiDeviceHardwareFirmwareVerKey, pInfo.getFirmwareVer());
                hardwareInfo.put(XPGWifiDeviceHardwareMCUHardVerKey, pInfo.getMcuHardVer());
                hardwareInfo.put(XPGWifiDeviceHardwareMCUSoftVerKey, pInfo.getMcuSoftVer());
                hardwareInfo.put(XPGWifiDeviceHardwareProductKey, pInfo.getProductKey());
                hardwareInfo.put(XPGWifiDeviceHardwareWifiHardVerKey, pInfo.getWifiHardVer());
                hardwareInfo.put(XPGWifiDeviceHardwareWifiSoftVerKey, pInfo.getWifiSoftVer());
                XPGWifiDevice.this.mListener.didQueryHardwareInfo(XPGWifiDevice.this.device, error, hardwareInfo);
                GizLogger.d("XPGWifiSDK", "didQueryHardwareInfo callback come back\uff0cYeah\uff01");
            } else {
                GizLogger.d(XPGWifiDevice.TAG, "Success callback didQueryHardwareInfo, XPGWifiDeviceListener = null, " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress());
            }
        }

        @Override
        public void onDiscovered(int result, GWifiDeviceList devices) {
            if (XPGWifiDevice.this.device.isLAN()) {
                GizLogger.b("l_get_subdevice_resp", "result = " + result, "LAN device get subdevice: mac = " + XPGWifiDevice.this.device.getMacAddress() + ", did = " + XPGWifiDevice.this.device.getDid() + ", subDevices_number = " + devices.GetCount());
            } else {
                GizLogger.b("m_get_subdevice_resp", "result = " + result, "MQTT device get subdevice: mac = " + XPGWifiDevice.this.device.getMacAddress() + ", did = " + XPGWifiDevice.this.device.getDid() + ", subDevices_number = " + devices.GetCount());
            }
            GizLogger.d(XPGWifiDevice.TAG, "Success callback " + XPGWifiDevice.this.device + ": " + XPGWifiDevice.this.device.getMacAddress() + " didDiscovered " + devices.GetCount() + " subDevices, XPGWifiDeviceListener " + (XPGWifiDevice.this.mListener == null ? "= null" : XPGWifiDevice.this.mListener));
            if (XPGWifiDevice.this.mListener != null && XPGWifiDeviceType.XPGWifiDeviceTypeCenterControl == XPGWifiDevice.this.type()) {
                ArrayList<XPGWifiSubDevice> devicesList = new ArrayList<XPGWifiSubDevice>();
                int i = 0;
                while ((long)i < devices.GetCount()) {
                    if (GWifiDeviceType.GWifiDeviceTypeSub.swigValue() == devices.GetItem(i).getDevType()) {
                        XPGWifiSubDevice newDevice = new XPGWifiSubDevice(devices.GetItem(i));
                        devicesList.add(newDevice);
                    }
                    ++i;
                }
                ((XPGWifiCentralControlDeviceListener)XPGWifiDevice.this.mListener).didDiscovered(result, devicesList);
            }
        }
    };

    protected XPGWifiDevice(GWifiDevice device, boolean isDidSetWifi) {
        this.originConfigDevice = device;
    }

    protected XPGWifiDevice(GWifiDevice device) {
        this.device = this;
        this.originDevice = device;
        device.setListener(this.listener);
    }

    public void setListener(XPGWifiDeviceListener listener) {
        String mac = "";
        if (this.device != null) {
            mac = this.device.getMacAddress();
        }
        GizLogger.d(TAG, " setListener: " + listener + ", " + this.device + ": " + mac);
        this.mListener = listener;
    }

    public String getMacAddress() {
        if (this.originDevice != null) {
            return this.originDevice.GetMacAddress();
        }
        if (this.originConfigDevice != null) {
            return this.originConfigDevice.GetMacAddress();
        }
        return "";
    }

    public String getDid() {
        if (this.originDevice != null) {
            return this.originDevice.GetDid();
        }
        if (this.originConfigDevice != null) {
            return this.originConfigDevice.GetDid();
        }
        return "";
    }

    public String getPasscode() {
        if (this.originDevice != null) {
            return this.originDevice.GetPasscode();
        }
        if (this.originConfigDevice != null) {
            return this.originConfigDevice.GetPasscode();
        }
        return "";
    }

    public String getIPAddress() {
        if (this.originDevice != null) {
            return this.originDevice.GetIPAddress();
        }
        if (this.originConfigDevice != null) {
            return this.originConfigDevice.GetIPAddress();
        }
        return "";
    }

    public String getProductKey() {
        String productkey = null;
        if (this.originDevice != null) {
            productkey = this.originDevice.GetProductKey();
            if (productkey == null || productkey.length() == 0) {
                productkey = "Default";
            }
            return productkey;
        }
        if (this.originConfigDevice != null) {
            productkey = this.originConfigDevice.GetProductKey();
            if (productkey == null || productkey.length() == 0) {
                productkey = "Default";
            }
            return productkey;
        }
        return "Default";
    }

    public String getProductName() {
        if (this.originDevice != null) {
            return this.originDevice.GetProductName();
        }
        if (this.originConfigDevice != null) {
            return this.originConfigDevice.GetProductName();
        }
        return "";
    }

    public String getRemark() {
        if (this.originDevice != null) {
            return this.originDevice.GetRemark();
        }
        return "";
    }

    public boolean isConnected() {
        if (this.originDevice != null) {
            return this.originDevice.getLogined();
        }
        return false;
    }

    public boolean isLAN() {
        if (this.originDevice != null) {
            return this.originDevice.IsLAN();
        }
        if (this.originConfigDevice != null) {
            return this.originConfigDevice.IsLAN();
        }
        return false;
    }

    public boolean isOnline() {
        if (this.originDevice != null) {
            return this.originDevice.IsOnline();
        }
        return false;
    }

    public boolean isDisabled() {
        if (this.originDevice != null) {
            return this.originDevice.getDisabled();
        }
        return false;
    }

    public XPGWifiDeviceType type() {
        if (this.originDevice != null) {
            if (GWifiDeviceType.GWifiDeviceTypeCenterControl.swigValue() == this.originDevice.getDevType()) {
                return XPGWifiDeviceType.XPGWifiDeviceTypeCenterControl;
            }
            return XPGWifiDeviceType.XPGWifiDeviceTypeNormal;
        }
        if (this.originConfigDevice != null) {
            if (GWifiDeviceType.GWifiDeviceTypeCenterControl.swigValue() == this.originConfigDevice.getDevType()) {
                return XPGWifiDeviceType.XPGWifiDeviceTypeCenterControl;
            }
            return XPGWifiDeviceType.XPGWifiDeviceTypeNormal;
        }
        return XPGWifiDeviceType.XPGWifiDeviceTypeNormal;
    }

    public void getHardwareInfo() {
        if (this.device.isLAN()) {
            GizLogger.b("l_get_hardware_info_req", null, "LAN device get hw info: mac = " + this.device.getMacAddress());
        } else {
            GizLogger.b("m_get_hardware_info_req", null, "MQTT device get hw info: mac = " + this.device.getMacAddress());
        }
        if (this.originDevice != null) {
            this.originDevice.GetHardwareInfo();
        }
    }

    protected boolean setLogParam(int nLogLevel, boolean bSwitchAll) {
        if (this.originDevice != null) {
            return this.originDevice.SetLogParam(nLogLevel, bSwitchAll);
        }
        return false;
    }

    public void disconnect() {
        if (this.device.isLAN()) {
            GizLogger.b("l_disconnect_start", null, "LAN device disconnect start: mac = " + this.device.getMacAddress());
        } else {
            GizLogger.b("m_disconnect_start", null, "MQTT device disconnect start: mac = " + this.device.getMacAddress() + ", did = " + this.device.getDid());
        }
        if (this.originDevice == null) {
            GizLogger.d(TAG, "try to disconnect: " + this.device + ", mListener = " + this.mListener);
            if (this.mListener != null) {
                this.mListener.didDisconnected(this.device, GWifiErrorCode.GWifiError_INVALID_PARAM.swigValue());
            }
            return;
        }
        if (!this.originDevice.Disconnect()) {
            GizLogger.d(TAG, "try to disconnect: " + this.device + ", mListener = " + this.mListener);
            if (this.mListener != null) {
                this.mListener.didDisconnected(this.device, GWifiErrorCode.GWifiError_GENERAL.swigValue());
            }
        }
    }

    public void login(String uid, String token) {
        if (this.device.isLAN()) {
            GizLogger.b("l_login_req", null, "LAN device login: mac = " + this.device.getMacAddress());
        } else {
            GizLogger.b("m_login_req", null, "MQTT device login: mac = " + this.device.getMacAddress() + ", did = " + this.device.getDid());
        }
        GizLogger.d(TAG, "try to login......" + this.device);
        if (this.originDevice == null) {
            if (this.mListener != null) {
                GizLogger.d(TAG, "invalid device login: " + this.device + ", " + this.mListener);
                this.mListener.didLogin(this.device, GWifiErrorCode.GWifiError_INVALID_PARAM.swigValue());
            } else {
                GizLogger.d(TAG, "invalid device login: " + this.device + ", mListener is null");
            }
            return;
        }
        if (this.originDevice.getLogining()) {
            GizLogger.d(TAG, "device is loginning");
            return;
        }
        if (this.originDevice.getLogined()) {
            if (this.mListener != null) {
                GizLogger.d(TAG, "device is logined: " + this.device + ", " + this.mListener);
                this.mListener.didLogin(this.device, GWifiErrorCode.GWifiError_NONE.swigValue());
            } else {
                GizLogger.d(TAG, "device is logined: " + this.device + ", mListener is null");
            }
            return;
        }
        this.originDevice.setLogining(true);
        this.originDevice.setLogined(false);
        this.originDevice.setToken(token);
        this.originDevice.setUid(uid);
        this.originDevice.Login(uid, token);
    }

    public boolean isBind(String uid) {
        if (this.originDevice != null) {
            return this.originDevice.IsBind(uid);
        }
        return false;
    }

    public void write(String jsonData) {
        if (this.device.isLAN()) {
            GizLogger.b("l_control_req", null, "LAN device control: mac = " + this.device.getMacAddress() + ", data = " + jsonData);
        } else {
            GizLogger.b("m_control_req", null, "MQTT device login: mac = " + this.device.getMacAddress() + ", did = " + this.device.getDid() + ", data = " + jsonData);
        }
        if (this.originDevice == null) {
            if (this.mListener != null) {
                GizLogger.d(TAG, "originDevice is null, mListener = " + this.mListener);
                this.mListener.didReceiveData(this.device, null, GWifiErrorCode.GWifiError_INVALID_PARAM.swigValue());
            } else {
                GizLogger.d(TAG, "originDevice is null, mListener is null too");
            }
            return;
        }
        int result = this.originDevice.write(jsonData);
        if (result != 0) {
            if (this.mListener != null) {
                GizLogger.d(TAG, "write failed: " + result + ", mListener = " + this.mListener);
                this.mListener.didReceiveData(this.device, null, result);
            } else {
                GizLogger.d(TAG, "write failed: " + result + ", mListener is null too");
            }
        }
    }

    public static enum XPGWifiDeviceType {
        XPGWifiDeviceTypeNormal,
        XPGWifiDeviceTypeCenterControl;

    }
}

