/*
 * Decompiled with CFR 0.152.
 */
package com.xtremeprog.xpgconnect;

import com.xtremeprog.xpgconnect.GizLogger;
import com.xtremeprog.xpgconnect.XPGWifiGroupListener;
import com.xtremeprog.xpgconnect.XPGWifiSDK;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class XPGWifiGroup {
    static final String TAG = "XPGWifiGroup";
    private JSONObject groupJson;
    private XPGWifiGroupListener mListener;
    private String uid;
    public String gid;
    public String productKey;
    public String groupName;

    protected XPGWifiGroup(JSONObject json) {
        this.groupJson = json;
        try {
            this.gid = this.groupJson.getString("gid");
            this.productKey = this.groupJson.getString("productKey");
            this.groupName = this.groupJson.getString("groupName");
            this.uid = this.groupJson.getString("uid");
            this.groupJson.remove("uid");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setListener(XPGWifiGroupListener listener) {
        this.mListener = listener;
    }

    protected static String getGroupConfigFilePath(String uid) {
        String groupConfigFilePath = "";
        if (XPGWifiSDK.mContext != null) {
            return XPGWifiSDK.mContext.getFilesDir() + "/XPGWifiSDK/GroupConfigInfo/" + uid + "_group.json";
        }
        GizLogger.d(TAG, "The context is null, please startWithAppID first!");
        return groupConfigFilePath;
    }

    protected static String readFromFile(String path) {
        String content = new String();
        File file = new File(path);
        if (file.exists()) {
            try {
                FileReader reader = new FileReader(file);
                char[] chars = new char[(int)file.length()];
                reader.read(chars);
                content = new String(chars);
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    protected static String writeToFile(String str, String path) {
        String content = null;
        File file = new File(path);
        File folder = new File(path.substring(0, path.lastIndexOf(47)));
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(str);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    protected static JSONArray getGroupConfigJson(String uid) throws JSONException {
        JSONArray groupArray = new JSONArray();
        String groupJsonStr = XPGWifiGroup.readFromFile(XPGWifiGroup.getGroupConfigFilePath(uid));
        if (groupJsonStr.length() > 0) {
            groupArray = new JSONArray(groupJsonStr);
        }
        return groupArray;
    }

    protected static JSONArray removeJSONArray(JSONArray jsonArray, int pos) {
        JSONArray newJsonArray = new JSONArray();
        try {
            int i = 0;
            while (i < jsonArray.length()) {
                if (i != pos) {
                    newJsonArray.put(jsonArray.get(i));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newJsonArray;
    }

    private void tiggerDevicesNotify() {
        if (this.groupJson != null) {
            ArrayList<ConcurrentHashMap<String, String>> devicesList = new ArrayList<ConcurrentHashMap<String, String>>();
            try {
                JSONArray devices = this.groupJson.getJSONArray("devices");
                int i = 0;
                while (i < devices.length()) {
                    ConcurrentHashMap<String, String> deviceMap = new ConcurrentHashMap<String, String>();
                    deviceMap.put("did", devices.getJSONObject(i).getString("did"));
                    deviceMap.put("sdid", devices.getJSONObject(i).getString("sdid"));
                    devicesList.add(deviceMap);
                    ++i;
                }
                if (this.mListener != null) {
                    this.mListener.didGetDevices(0, devicesList);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if (this.mListener != null) {
            this.mListener.didGetDevices(-1, null);
        }
    }

    public void getDevices() {
        this.tiggerDevicesNotify();
    }

    private void syncGroupJsonToFile() throws JSONException {
        JSONArray groupArray = XPGWifiGroup.getGroupConfigJson(this.uid);
        int i = 0;
        while (i < groupArray.length()) {
            if (groupArray.getJSONObject(i).getString("gid").equals(this.gid)) {
                groupArray.put(i, (Object)this.groupJson);
                XPGWifiGroup.writeToFile(groupArray.toString(), XPGWifiGroup.getGroupConfigFilePath(this.uid));
                this.tiggerDevicesNotify();
                break;
            }
            ++i;
        }
    }

    public void addDevice(String did, String sdid) {
        if (this.groupJson != null) {
            try {
                JSONArray devices = new JSONArray();
                JSONObject device = new JSONObject();
                device.put("did", (Object)did);
                device.put("sdid", (Object)sdid);
                if (this.groupJson.has("devices")) {
                    devices = this.groupJson.getJSONArray("devices");
                    int i = 0;
                    while (i < devices.length()) {
                        if (devices.getJSONObject(i).getString("sdid").equals(sdid) && devices.getJSONObject(i).getString("did").equals(did)) break;
                        ++i;
                    }
                    if (i == devices.length()) {
                        devices.put((Object)device);
                    }
                } else {
                    devices.put((Object)device);
                }
                this.groupJson.put("devices", (Object)devices);
                this.syncGroupJsonToFile();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.mListener.didGetDevices(-1, null);
    }

    public void removeDevice(String did, String sdid) {
        if (this.groupJson != null) {
            try {
                if (this.groupJson.has("devices")) {
                    JSONArray devices = this.groupJson.getJSONArray("devices");
                    int i = 0;
                    while (i < devices.length()) {
                        if (devices.getJSONObject(i).getString("sdid").equals(sdid) && devices.getJSONObject(i).getString("did").equals(did)) {
                            devices = XPGWifiGroup.removeJSONArray(devices, i);
                            this.groupJson.put("devices", (Object)devices);
                            break;
                        }
                        ++i;
                    }
                }
                this.syncGroupJsonToFile();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.mListener.didGetDevices(-1, null);
    }
}

