/*
 * Decompiled with CFR 0.152.
 */
package com.xtremeprog.xpgconnect;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IntentFilter;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import com.espressif.iot.esptouch.Esptouch;
import com.mxchip.easylink.EasyLinkAPI;
import com.xtremeprog.xpgconnect.GUserInfo;
import com.xtremeprog.xpgconnect.GUserInfo_st;
import com.xtremeprog.xpgconnect.GWifiConfig;
import com.xtremeprog.xpgconnect.GWifiDevice;
import com.xtremeprog.xpgconnect.GWifiDeviceList;
import com.xtremeprog.xpgconnect.GWifiDeviceType;
import com.xtremeprog.xpgconnect.GWifiErrorCode;
import com.xtremeprog.xpgconnect.GWifiLogLevel;
import com.xtremeprog.xpgconnect.GWifiSDK;
import com.xtremeprog.xpgconnect.GWifiSDKListener;
import com.xtremeprog.xpgconnect.GWifiSSIDList;
import com.xtremeprog.xpgconnect.GWifiUserType;
import com.xtremeprog.xpgconnect.GizLogger;
import com.xtremeprog.xpgconnect.HFSnifferSmartLinker;
import com.xtremeprog.xpgconnect.NetStatusReceiver;
import com.xtremeprog.xpgconnect.RTKSimpleConfigManager;
import com.xtremeprog.xpgconnect.XPGUserInfo;
import com.xtremeprog.xpgconnect.XPGWifiCentralControlDevice;
import com.xtremeprog.xpgconnect.XPGWifiDevice;
import com.xtremeprog.xpgconnect.XPGWifiGroup;
import com.xtremeprog.xpgconnect.XPGWifiSDKListener;
import com.xtremeprog.xpgconnect.XPGWifiSSID;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class XPGWifiSDK {
    private static final String TAG = "XPGWifiSDK";
    protected static Context mContext;
    private static XPGWifiSDK mInstance;
    private static XPGWifiSDKListener mListener;
    private static Thread wifiConfigThread;
    private static int wifiConfigInterval;
    private static int wifiConfigTimeout;
    private static int wifiConfigCount;
    private static String wifiConfigSSID;
    private static String wifiConfigKey;
    public EasyLinkAPI elapi;
    private static GWifiSDKListener sdkListener;

    static {
        mInstance = new XPGWifiSDK();
        wifiConfigThread = null;
        wifiConfigInterval = 500;
        wifiConfigTimeout = 30;
        wifiConfigCount = 0;
        wifiConfigSSID = null;
        wifiConfigKey = null;
        sdkListener = new GWifiSDKListener(){

            @Override
            public void onGetSSIDList(GWifiSSIDList list, int result) {
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didGetSSIDList, result = " + result + "XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null && result == 0) {
                    ArrayList<XPGWifiSSID> ssidInfoList = new ArrayList<XPGWifiSSID>();
                    WifiManager wifiManager = (WifiManager)mContext.getSystemService("wifi");
                    ArrayList scanlist = (ArrayList)wifiManager.getScanResults();
                    if (scanlist != null) {
                        int i = 0;
                        while (i < scanlist.size()) {
                            ssidInfoList.add(new XPGWifiSSID(((ScanResult)scanlist.get((int)i)).SSID, (short)((ScanResult)scanlist.get((int)i)).level));
                            ++i;
                        }
                    }
                    GizLogger.b("get_softap_ssidlist_resp", "result = " + result, "ssids_number = " + ssidInfoList.size());
                    mListener.didGetSSIDList(result, ssidInfoList);
                    GizLogger.d(XPGWifiSDK.TAG, "didGetSSIDList callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onSetAirLink(GWifiDevice device, int result) {
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didSetDeviceWifi, result = " + result + ", XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    String currentSSID;
                    if (GWifiErrorCode.GWifiError_CONFIGURE_TIMEOUT.swigValue() == result && (currentSSID = NetStatusReceiver.getCurentWifiSSID(mContext)) != null && currentSSID.compareTo(wifiConfigSSID) != 0) {
                        GizLogger.b("onboarding_recv", "result = " + result, null);
                        mListener.didSetDeviceWifi(-39, null);
                        GizLogger.d(XPGWifiSDK.TAG, "didSetDeviceWifi callback come back\uff0cYeah\uff01");
                        return;
                    }
                    if (GWifiErrorCode.GWifiError_NONE.swigValue() != result) {
                        GizLogger.b("onboarding_recv", "result = " + result, null);
                        mListener.didSetDeviceWifi(result, null);
                        GizLogger.d(XPGWifiSDK.TAG, "didSetDeviceWifi callback come back\uff0cYeah\uff01");
                    } else {
                        XPGWifiDevice newDevice = new XPGWifiDevice(device, true);
                        GizLogger.b("onboarding_recv", "result = " + result, "mac = " + newDevice.getMacAddress());
                        GizLogger.d(XPGWifiSDK.TAG, "didSetDeviceWifi: newDevice = " + newDevice + ", mac = " + newDevice.getMacAddress());
                        mListener.didSetDeviceWifi(0, newDevice);
                        GizLogger.d(XPGWifiSDK.TAG, "didSetDeviceWifi callback come back\uff0cYeah\uff01");
                    }
                }
            }

            @Override
            public void onDiscovered(int result, GWifiDeviceList devices) {
                GizLogger.b("discovered_recv", null, "discovered: devices number = " + devices.GetCount());
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didDiscovered, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    ArrayList<XPGWifiDevice> devicesList = new ArrayList<XPGWifiDevice>();
                    int i = 0;
                    while ((long)i < devices.GetCount()) {
                        XPGWifiDevice newDevice;
                        if (GWifiDeviceType.GWifiDeviceTypeCenterControl.swigValue() == devices.GetItem(i).getDevType()) {
                            newDevice = new XPGWifiCentralControlDevice(devices.GetItem(i));
                            devicesList.add(newDevice);
                            GizLogger.d(XPGWifiSDK.TAG, "didDiscovered " + devices.GetCount() + " devices: " + newDevice + ", mac: " + newDevice.getMacAddress());
                        } else {
                            newDevice = new XPGWifiDevice(devices.GetItem(i));
                            devicesList.add(newDevice);
                            GizLogger.d(XPGWifiSDK.TAG, "didDiscovered " + devices.GetCount() + " devices: " + newDevice + ", mac: " + newDevice.getMacAddress());
                        }
                        ++i;
                    }
                    mListener.didDiscovered(result, devicesList);
                    GizLogger.d(XPGWifiSDK.TAG, "didDiscovered callback come back\uff0cYeah\uff01");
                }
            }

            public void onUpdateProduct(String productKey, int result) {
                GizLogger.b("get_captcha_resp", null, "download productkey response: " + productKey);
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didUpdateProduct, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    mListener.didUpdateProduct(result, productKey);
                    GizLogger.d(XPGWifiSDK.TAG, "didUpdateProduct callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onRequestSendVerifyCode(int error, String errorMessage) {
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didRequestSendVerifyCode, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    mListener.didRequestSendVerifyCode(error, errorMessage);
                    GizLogger.d(XPGWifiSDK.TAG, "didRequestSendVerifyCode callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onGetCaptchaCode(String token, String captchaId, String captchaURL, int error, String errorMessage) {
                GizLogger.b("get_captcha_resp", errorMessage, "get captcha result: capthaId = " + captchaId + ", url = " + captchaURL);
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didGetCaptchaCode, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    mListener.didGetCaptchaCode(error, errorMessage, token, captchaId, captchaURL);
                    GizLogger.d(XPGWifiSDK.TAG, "didGetCaptchaCode callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onRequestSendPhoneSMSCode(int error, String errorMessage) {
                GizLogger.b("get_sms_resp", errorMessage, "get sms result");
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didRequestSendPhoneSMSCode, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    mListener.didRequestSendPhoneSMSCode(error, errorMessage);
                    GizLogger.d(XPGWifiSDK.TAG, "didRequestSendPhoneSMSCode callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onVerifyPhoneSMSCode(int error, String errorMessage) {
                GizLogger.b("sms_verify_resp", errorMessage, "sms verify result");
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didVerifyPhoneSMSCode, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    mListener.didVerifyPhoneSMSCode(error, errorMessage);
                    GizLogger.d(XPGWifiSDK.TAG, "didVerifyPhoneSMSCode callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onRegisterUser(int error, String errorMessage, String uid, String token) {
                GizLogger.b("user_register_resp", errorMessage, "user register result: uid = " + uid + ", token = " + token);
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didTransUser, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    mListener.didRegisterUser(error, errorMessage, uid, token);
                    GizLogger.d(XPGWifiSDK.TAG, "didRegisterUser callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onUserLogin(int error, String errorMessage, String uid, String token) {
                GizLogger.b("user_login_resp", errorMessage, "user login result: uid = " + uid + ", token = " + token);
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didTransUser, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    mListener.didUserLogin(error, errorMessage, uid, token);
                    GizLogger.d(XPGWifiSDK.TAG, "didUserLogin callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onUserLogout(int error, String errorMessage) {
                GizLogger.d(XPGWifiSDK.TAG, "Success callback didUserLogout, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    mListener.didUserLogout(error, errorMessage);
                    GizLogger.d(XPGWifiSDK.TAG, "didUserLogout callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onTransUser(int error, String errorMessage) {
                GizLogger.b("anony_user_transfer_resp", errorMessage, "anony user trans result");
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didTransUser, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    mListener.didTransUser(error, errorMessage);
                    GizLogger.d(XPGWifiSDK.TAG, "didTransUser callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onChangeUserPassword(int error, String errorMessage) {
                GizLogger.b("change_password_resp", errorMessage, "change user password result");
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didChangeUserPassword, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    mListener.didChangeUserPassword(error, errorMessage);
                    GizLogger.d(XPGWifiSDK.TAG, "didChangeUserPassword callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onChangeUserEmail(int error, String errorMessage) {
                if (mListener != null) {
                    GizLogger.d(XPGWifiSDK.TAG, "Success callback didChangeUserEmail, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                    mListener.didChangeUserEmail(error, errorMessage);
                    GizLogger.d(XPGWifiSDK.TAG, "didChangeUserEmail callback come back\uff0cYeah\uff01");
                    GizLogger.d(XPGWifiSDK.TAG, "Success callback didChangeUserInfo, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                    mListener.didChangeUserInfo(error, errorMessage);
                    GizLogger.d(XPGWifiSDK.TAG, "didChangeUserInfo callback come back\uff0cYeah\uff01");
                } else {
                    GizLogger.d(XPGWifiSDK.TAG, "Success callback onChangeUserPhone: XPGWifiSDKListener = null");
                }
            }

            @Override
            public void onChangeUserPhone(int error, String errorMessage) {
                if (mListener != null) {
                    GizLogger.d(XPGWifiSDK.TAG, "Success callback didChangeUserPhone, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                    mListener.didChangeUserPhone(error, errorMessage);
                    GizLogger.d(XPGWifiSDK.TAG, "didChangeUserPhone callback come back\uff0cYeah\uff01");
                    GizLogger.d(XPGWifiSDK.TAG, "Success callback didChangeUserInfo, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                    mListener.didChangeUserInfo(error, errorMessage);
                    GizLogger.d(XPGWifiSDK.TAG, "didChangeUserInfo callback come back\uff0cYeah\uff01");
                } else {
                    GizLogger.d(XPGWifiSDK.TAG, "Success callback onChangeUserPhone: XPGWifiSDKListener = null");
                }
            }

            @Override
            public void onChangeUserInfo(int error, String errorMessage) {
                GizLogger.b("change_user_info_resp", errorMessage, "change user info result");
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didChangeUserInfo, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    mListener.didChangeUserInfo(error, errorMessage);
                    GizLogger.d(XPGWifiSDK.TAG, "didChangeUserInfo callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onGetUserInfo(int error, String errorMessage, GUserInfo userInfo) {
                GizLogger.b("get_user_info_resp", errorMessage, "get user info result");
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didBindDevice, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    XPGUserInfo mUserInfo = null;
                    if (error == 0) {
                        mUserInfo = new XPGUserInfo();
                        mUserInfo.setUid(userInfo.getUid());
                        mUserInfo.setUsername(userInfo.getUsername());
                        mUserInfo.setEmail(userInfo.getEmail());
                        mUserInfo.setPhone(userInfo.getPhone());
                        mUserInfo.setAnonymous(userInfo.getIs_anonymous());
                        mUserInfo.setName(userInfo.getName());
                        int gender = userInfo.getGender();
                        if (gender == 0) {
                            mUserInfo.setGender(XPGUserGenderType.Male);
                        } else if (gender == 1) {
                            mUserInfo.setGender(XPGUserGenderType.Female);
                        } else {
                            mUserInfo.setGender(XPGUserGenderType.Unknown);
                        }
                        mUserInfo.setBirthday(userInfo.getBirthday());
                        mUserInfo.setAddress(userInfo.getAddress());
                        mUserInfo.setLang(userInfo.getLang());
                        mUserInfo.setRemark(userInfo.getRemark());
                    }
                    mListener.didGetUserInfo(error, errorMessage, mUserInfo);
                    GizLogger.d(XPGWifiSDK.TAG, "didGetUserInfo callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onBindDevice(String did, int error, String errorMessage) {
                GizLogger.b("dev_bind_resp", errorMessage, "device bind result: did = " + did);
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didBindDevice, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    mListener.didBindDevice(error, errorMessage, did);
                    GizLogger.d(XPGWifiSDK.TAG, "didBindDevice callback come back\uff0cYeah\uff01");
                }
            }

            @Override
            public void onUnbindDevice(String did, int error, String errorMessage) {
                GizLogger.b("dev_unbind_resp", errorMessage, "device bind result: did = " + did);
                GizLogger.d(XPGWifiSDK.TAG, "ready to callback didUnbindDevice, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
                if (mListener != null) {
                    mListener.didUnbindDevice(error, errorMessage, did);
                    GizLogger.d(XPGWifiSDK.TAG, "didUnbindDevice callback come back\uff0cYeah\uff01");
                }
            }
        };
    }

    private XPGWifiSDK() {
    }

    public static XPGWifiSDK sharedInstance() {
        return mInstance;
    }

    public void startWithAppID(Context context, String appID) {
        GizLogger.b("init_start", "", "SDK started: version = " + this.getVersion() + "appID = " + appID);
        if (context == null) {
            GizLogger.b("init_result", "XPGWifiError_START_SDK_FAILED", "the context is null");
            GizLogger.e(TAG, "the context is null");
            return;
        }
        if (GWifiConfig.sharedInstance() == null) {
            GizLogger.b("init_result", "XPGWifiError_START_SDK_FAILED", "the GWifiConfig shared instance is null");
            GizLogger.e(TAG, "the GWifiConfig shared instance is null");
            return;
        }
        if (GWifiSDK.sharedInstance() == null) {
            GizLogger.b("init_result", "XPGWifiError_START_SDK_FAILED", "the GWifiSDK shared instance is null");
            GizLogger.e(TAG, "the GWifiSDK shared instance is null");
            return;
        }
        mContext = context;
        GWifiConfig.sharedInstance().SetAppID(appID);
        GWifiConfig.sharedInstance().SetDebug(true);
        GWifiConfig.sharedInstance().SetProductPath(context.getFilesDir() + "/XPGWifiSDK/Devices");
        GWifiSDK.sharedInstance().setListener(sdkListener);
        XPGWifiSDK.registerBroadCastReceiver();
        GizLogger.b("init_result", "XPGWifiError_NONE", null);
        GizLogger.d(TAG, "start sdk success: version = " + this.getVersion() + ", appID = " + appID);
    }

    public String getVersion() {
        return GWifiSDK.sharedInstance().getVersion();
    }

    public void setListener(XPGWifiSDKListener listener) {
        mListener = listener;
        GizLogger.d(TAG, "set sdk listener: " + mListener);
    }

    private static void registerBroadCastReceiver() {
        NetStatusReceiver receiver = new NetStatusReceiver();
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        mContext.registerReceiver((BroadcastReceiver)receiver, filter);
    }

    public void setCloudService(String openAPIDomain, int openAPIPort, String siteDomain, int sitePort) {
        GizLogger.d(TAG, "try to switch cloud service: api = " + openAPIDomain + ":" + openAPIPort + ", site = " + siteDomain + ":" + sitePort);
        boolean result = GWifiConfig.sharedInstance().SetCloudService(openAPIDomain, openAPIPort, siteDomain, sitePort);
        if (result) {
            this.getCurrentCloudService();
        } else {
            GizLogger.d(TAG, "ready to callback didGetCurrentCloudService, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
            if (mListener != null) {
                mListener.didGetCurrentCloudService(GWifiErrorCode.GWifiError_INVALID_PARAM.swigValue(), "XPGWifiError_INVALID_PARAM", null);
                GizLogger.d(TAG, "didGetCurrentCloudService callback come back\uff0cYeah\uff01");
            }
        }
    }

    public void getCurrentCloudService() {
        GizLogger.d(TAG, "try to get current cloud service info");
        String api = GWifiConfig.sharedInstance().GetOpenAPIDomain();
        if (api == null) {
            api = "";
        }
        int apip = GWifiConfig.sharedInstance().GetOpenAPIPort();
        String site = GWifiConfig.sharedInstance().GetSiteDomain();
        if (site == null) {
            site = "";
        }
        int sitep = GWifiConfig.sharedInstance().GetSitePort();
        ConcurrentHashMap<String, String> domainInfo = new ConcurrentHashMap<String, String>();
        domainInfo.put("openAPIDomain", api);
        domainInfo.put("openAPIPort", String.valueOf(apip));
        domainInfo.put("siteDomain", site);
        domainInfo.put("sitePort", String.valueOf(sitep));
        GizLogger.d(TAG, "ready to callback didGetCurrentCloudService, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
        if (mListener != null) {
            mListener.didGetCurrentCloudService(GWifiErrorCode.GWifiError_NONE.swigValue(), "XPGWifiError_NONE", domainInfo);
            GizLogger.d(TAG, "didGetCurrentCloudService callback come back\uff0cYeah\uff01");
        }
    }

    public void setLogLevel(XPGWifiLogLevel logLevel, String logFile, boolean bPrintDataInDebug) {
        GizLogPrintLevel logPrintLevel = GizLogPrintLevel.GizLogPrintAll;
        boolean writeSDCard = false;
        if (XPGWifiLogLevel.XPGWifiLogLevelError == logLevel) {
            logPrintLevel = GizLogPrintLevel.GizLogPrintI;
        } else if (XPGWifiLogLevel.XPGWifiLogLevelWarning == logLevel) {
            logPrintLevel = GizLogPrintLevel.GizLogPrintII;
        }
        if (bPrintDataInDebug) {
            logPrintLevel = GizLogPrintLevel.GizLogPrintAll;
        }
        if (logFile != null) {
            writeSDCard = true;
        }
        this.setLogLevel(logPrintLevel, writeSDCard);
    }

    public void setLogLevel(GizLogPrintLevel logPrintLevel, boolean writeSDCard) {
        GWifiLogLevel printLevel = GWifiLogLevel.GWifiLogLevelAll;
        String logPath = "";
        if (mContext != null) {
            logPath = mContext.getFilesDir().getAbsolutePath();
        }
        if (writeSDCard) {
            logPath = this.getSDCardPath();
        }
        JSONObject sysInfo = new JSONObject();
        try {
            sysInfo.put("phone_id", (Object)this.getPhoneID());
            sysInfo.put("os", (Object)"Android");
            sysInfo.put("os_ver", (Object)Build.VERSION.RELEASE);
            sysInfo.put("phone_model", (Object)Build.MODEL);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (mInstance == null) {
            GizLogger.d(TAG, "Please startWithAppID first!");
            return;
        }
        printLevel = GizLogPrintLevel.GizLogPrintNone == logPrintLevel ? GWifiLogLevel.GWifiLogLevelNone : (GizLogPrintLevel.GizLogPrintI == logPrintLevel ? GWifiLogLevel.GWifiLogLevelError : (GizLogPrintLevel.GizLogPrintII == logPrintLevel ? GWifiLogLevel.GWifiLogLevelDebug : GWifiLogLevel.GWifiLogLevelAll));
        GWifiSDK.SetLogLevel(sysInfo.toString(), logPath, printLevel);
        GizLogger.d(TAG, "SetLog success!");
    }

    private String getSDCardPath() {
        File sdDir = null;
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        if (sdCardExist) {
            sdDir = Environment.getExternalStorageDirectory();
        }
        return sdDir.toString();
    }

    public void registerSSID(String ... ssidPrefixs) {
        if (ssidPrefixs != null && ssidPrefixs.length > 0) {
            GWifiConfig.sharedInstance().ClearSSIDs();
            String[] stringArray = ssidPrefixs;
            int n = ssidPrefixs.length;
            int n2 = 0;
            while (n2 < n) {
                String ssidPrefix = stringArray[n2];
                GWifiConfig.sharedInstance().RegisterSSID(ssidPrefix);
                ++n2;
            }
        }
    }

    public void updateDeviceFromServer(String productKey) {
        GizLogger.b("site_down_json_http_req ", null, "download productkey: " + productKey);
        GizLogger.d(TAG, "begin to download productkey: " + productKey);
        GWifiConfig.sharedInstance().DownloadProduct(productKey);
    }

    private boolean isSoftAPMode() {
        String currentSSID = NetStatusReceiver.getCurentWifiSSID(mContext);
        if (currentSSID != null && currentSSID.length() != 0) {
            int i = 0;
            while (i < GWifiConfig.sharedInstance().GetSoftAPCount()) {
                String prefix = GWifiConfig.sharedInstance().GetSoftAPSSID(i);
                if (currentSSID.startsWith(prefix) || currentSSID.startsWith("\"" + prefix)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void setSoftAP(String ssid, String key, int timeout) {
        GizLogger.b("softap_send_start", null, "send softap config: ssid = " + ssid + ", key = " + key);
        GizLogger.d(TAG, "send softap config: ssid = " + ssid + ", key = " + key);
        if (!this.isSoftAPMode()) {
            GizLogger.b("softap_send_result", "GWifiError_NOT_IN_SOFTAPMODE", null);
            GizLogger.d(TAG, "ready to callback: GWifiError_NOT_IN_SOFTAPMODE");
            if (sdkListener != null) {
                sdkListener.onSetAirLink(null, GWifiErrorCode.GWifiError_NOT_IN_SOFTAPMODE.swigValue());
            } else {
                GizLogger.d(TAG, "Can not callback, XPGWifiSDKListener = null");
            }
            return;
        }
        if (timeout < 30) {
            timeout = 30;
        }
        wifiConfigTimeout = timeout;
        wifiConfigThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < wifiConfigTimeout * 1000 / wifiConfigInterval) {
                    if (GWifiSDK.sharedInstance().IsConfigureEnded()) break;
                    if (i % 6 == 0) {
                        GWifiSDK.sharedInstance().SetSSID(wifiConfigSSID, wifiConfigKey);
                    }
                    try {
                        Thread.sleep(wifiConfigInterval);
                        wifiConfigCount = wifiConfigCount + 1;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                GizLogger.b("softap_send_stop", null, "stop softap config");
                GizLogger.d(XPGWifiSDK.TAG, "stop softap config");
            }
        });
        wifiConfigThread.start();
    }

    public void setDeviceWifi(String ssid, String key, XPGWifiConfigureMode mode, int timeout) {
        this.setDeviceWifiInside2(ssid, key, mode, null, timeout);
    }

    public void setDeviceWifi(String ssid, String key, XPGWifiConfigureMode mode, String softAPSSIDPrefix, int timeout) {
        if (XPGWifiConfigureMode.XPGWifiConfigureModeSoftAP == mode && softAPSSIDPrefix != null && softAPSSIDPrefix.length() > 0) {
            GWifiConfig.sharedInstance().ClearSSIDs();
            GWifiConfig.sharedInstance().RegisterSSID(softAPSSIDPrefix);
        }
        this.setDeviceWifiInside2(ssid, key, mode, null, timeout);
    }

    public void getSSIDList() {
        if (mContext == null) {
            GizLogger.b("get_softap_ssidlist_resp", "GWifiError_INVALID_PARAM", "sdk didn't start");
            GizLogger.d(TAG, "ready to callback: GWifiError_INVALID_PARAM, context is null");
            if (sdkListener != null) {
                sdkListener.onSetAirLink(null, GWifiErrorCode.GWifiError_INVALID_PARAM.swigValue());
            } else {
                GizLogger.d(TAG, "Can not callback, XPGWifiSDKListener = null");
            }
            return;
        }
        GizLogger.d(TAG, "get softap ssidlist: softap_ssid = " + NetStatusReceiver.getCurentWifiSSID(mContext));
        GWifiSDK.sharedInstance().GetSSIDList();
    }

    public void setDeviceWifi(String ssid, String key, XPGWifiConfigureMode mode, String softAPSSIDPrefix, int timeout, List<XPGWifiGAgentType> types) {
        GizLogger.b("wifi_config_start", null, "wifi config\uff1assid = " + ssid + "key = " + key);
        GizLogger.d(TAG, "wifi config\uff1assid = " + ssid + "key = " + key);
        if (mContext == null) {
            GizLogger.b("wifi_config_result", "GWifiError_INVALID_PARAM", "sdk didn't start");
            GizLogger.d(TAG, "ready to callback: GWifiError_INVALID_PARAM, context is null");
            if (sdkListener != null) {
                sdkListener.onSetAirLink(null, GWifiErrorCode.GWifiError_INVALID_PARAM.swigValue());
            } else {
                GizLogger.d(TAG, "Can not callback, XPGWifiSDKListener = null");
            }
            return;
        }
        if (XPGWifiConfigureMode.XPGWifiConfigureModeSoftAP == mode && softAPSSIDPrefix != null && softAPSSIDPrefix.length() > 0) {
            GizLogger.d(TAG, "register softap ssid\uff1a" + softAPSSIDPrefix);
            GWifiConfig.sharedInstance().ClearSSIDs();
            GWifiConfig.sharedInstance().RegisterSSID(softAPSSIDPrefix);
        }
        this.setDeviceWifiInside2(ssid, key, mode, types, timeout);
    }

    private void setDeviceWifiInside2(String ssid, String key, XPGWifiConfigureMode mode, List<XPGWifiGAgentType> types, int timeout) {
        if (ssid == null) {
            GizLogger.b("wifi_config_result", "GWifiError_INVALID_PARAM", null);
            if (sdkListener != null) {
                sdkListener.onSetAirLink(null, GWifiErrorCode.GWifiError_INVALID_PARAM.swigValue());
            } else {
                GizLogger.d(TAG, "Can not callback, XPGWifiSDKListener = null");
            }
            return;
        }
        int errorCode = GWifiSDK.sharedInstance().StartConfigure(timeout);
        if (GWifiErrorCode.GWifiError_NONE.swigValue() != errorCode) {
            if (sdkListener != null) {
                sdkListener.onSetAirLink(null, errorCode);
            }
            GizLogger.b("wifi_config_result", "XPGWifiError_IS_RUNNING", null);
            return;
        }
        if (timeout < 30) {
            timeout = 30;
        }
        wifiConfigTimeout = timeout;
        wifiConfigSSID = ssid;
        wifiConfigKey = key;
        if (XPGWifiConfigureMode.XPGWifiConfigureModeSoftAP == mode) {
            GizLogger.b("softap_send_start", null, "send softap config: ssid = " + ssid + ", key = " + key);
            this.setSoftAP(ssid, key, timeout);
        } else if (types == null || types.size() == 0) {
            this.setSmartLink(ssid, key, wifiConfigTimeout, XPGWifiGAgentType.XPGWifiGAgentTypeMXCHIP, null);
            this.setSmartLink(ssid, key, wifiConfigTimeout, XPGWifiGAgentType.XPGWifiGAgentTypeHF, mContext);
        } else {
            for (XPGWifiGAgentType type : types) {
                if (!(type instanceof XPGWifiGAgentType)) continue;
                this.setSmartLink(ssid, key, wifiConfigTimeout, type, mContext);
            }
        }
    }

    private void setSmartLink(String ssid, String key, int timeout, XPGWifiGAgentType type, Context context) {
        String currentSSID = NetStatusReceiver.getCurentWifiSSID(mContext);
        if (currentSSID != null && currentSSID.compareTo(wifiConfigSSID) != 0) {
            GizLogger.b("wifi_config_result", "XPGWifiError_CONFIGURE_SSID_NOT_MATCHED", null);
            GizLogger.d(TAG, "ready to callback didSetDeviceWifi, result = XPGWifiError_CONFIGURE_SSID_NOT_MATCHED, XPGWifiSDKListener " + (mListener == null ? "= null" : "!= null"));
            mListener.didSetDeviceWifi(-39, null);
            GizLogger.d(TAG, "didSetDeviceWifi callback come back\uff0cYeah\uff01");
            return;
        }
        if (XPGWifiGAgentType.XPGWifiGAgentTypeMXCHIP != type) {
            class ConfigWaitThread
            extends Thread {
                public XPGWifiGAgentType type = XPGWifiGAgentType.XPGWifiGAgentTypeHF;

                public ConfigWaitThread(XPGWifiGAgentType type) {
                    this.type = type;
                }

                @Override
                public void run() {
                    int i = 0;
                    while (i < wifiConfigTimeout * 1000 / wifiConfigInterval) {
                        if (GWifiSDK.sharedInstance().IsConfigureEnded()) break;
                        try {
                            Thread.sleep(wifiConfigInterval);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    if (XPGWifiGAgentType.XPGWifiGAgentTypeHF == this.type) {
                        GizLogger.b("airlink_send_stop_hf", null, "stop config HF");
                        GizLogger.d(XPGWifiSDK.TAG, "stop config HF");
                        HFSnifferSmartLinker.sharedInstance().stop();
                    } else if (XPGWifiGAgentType.XPGWifiGAgentTypeRTK == this.type) {
                        GizLogger.b("airlink_send_stop_rtk", null, "stop config RTK");
                        GizLogger.d(XPGWifiSDK.TAG, "stop config RTK");
                        RTKSimpleConfigManager.sharedInstance().stopRTKSimpleConfig();
                    } else if (XPGWifiGAgentType.XPGWifiGAgentTypeWM == this.type) {
                        GizLogger.b("airlink_send_stop_wm", null, "stop config WM");
                        GizLogger.d(XPGWifiSDK.TAG, "stop config WM");
                    } else if (XPGWifiGAgentType.XPGWifiGAgentTypeESP == this.type) {
                        GizLogger.b("airlink_send_stop_esp", null, "stop config ESP");
                        GizLogger.d(XPGWifiSDK.TAG, "stop config ESP");
                        Esptouch.getInstance().stop();
                    } else if (XPGWifiGAgentType.XPGWifiGAgentTypeFSK == this.type) {
                        GizLogger.b("airlink_send_stop_fsk", null, "stop config FSK");
                        GizLogger.d(XPGWifiSDK.TAG, "stop config FSK");
                    } else if (XPGWifiGAgentType.XPGWifiGAgentTypeMXCHIP3 == this.type) {
                        GizLogger.b("airlink_send_stop_mxchip3", null, "stop config MXCHIP3");
                        GizLogger.d(XPGWifiSDK.TAG, "stop config MXCHIP3");
                        if (XPGWifiSDK.this.elapi != null) {
                            XPGWifiSDK.this.elapi.stopEasyLink();
                            XPGWifiSDK.this.elapi = null;
                        }
                    } else if (XPGWifiGAgentType.XPGWifiGAgentTypeBL == this.type) {
                        GizLogger.b("airlink_send_stop_bl", null, "stop config BL");
                        GizLogger.d(XPGWifiSDK.TAG, "stop config BL");
                    }
                }
            }
            wifiConfigThread = new ConfigWaitThread(type);
            wifiConfigThread.start();
        }
        if (XPGWifiGAgentType.XPGWifiGAgentTypeMXCHIP == type) {
            GizLogger.b("airlink_send_start_mxchip", null, "start config MXCHIP: ssid = " + ssid + ", key = " + key);
            GizLogger.d(TAG, "start config MXCHIP: ssid = " + ssid + ", key = " + key);
            GWifiSDK.sharedInstance().SetAirLink(ssid, key, timeout - 20);
        } else if (XPGWifiGAgentType.XPGWifiGAgentTypeHF == type) {
            GizLogger.b("airlink_send_start_hf", null, "start config HF: ssid = " + ssid + ", key = " + key);
            GizLogger.d(TAG, "start config HF: ssid = " + ssid + ", key = " + key);
            HFSnifferSmartLinker.sharedInstance().start(ssid, key, timeout, context);
        } else if (XPGWifiGAgentType.XPGWifiGAgentTypeRTK == type) {
            GizLogger.b("airlink_send_start_rtk", null, "start config RTK: ssid = " + ssid + ", key = " + key);
            GizLogger.d(TAG, "start config RTK: ssid = " + ssid + ", key = " + key);
            RTKSimpleConfigManager.sharedInstance().startRTKSimpleConfig(ssid, key, null, timeout, context);
        } else if (XPGWifiGAgentType.XPGWifiGAgentTypeWM == type) {
            GizLogger.b("airlink_send_start_wm", null, "start config WM: ssid = " + ssid + ", key = " + key);
            GizLogger.d(TAG, "start config WM: ssid = " + ssid + ", key = " + key);
        } else if (XPGWifiGAgentType.XPGWifiGAgentTypeESP == type) {
            GizLogger.b("airlink_send_start_esp", null, "start config ESP: ssid = " + ssid + ", key = " + key);
            GizLogger.d(TAG, "start config ESP: ssid = " + ssid + ", key = " + key);
            Esptouch.getInstance().start(ssid, key, context, timeout);
        } else if (XPGWifiGAgentType.XPGWifiGAgentTypeFSK == type) {
            GizLogger.b("airlink_send_start_fsk", null, "start config FSK: ssid = " + ssid + ", key = " + key);
            GizLogger.d(TAG, "start config FSK: ssid = " + ssid + ", key = " + key);
        } else if (XPGWifiGAgentType.XPGWifiGAgentTypeMXCHIP3 == type) {
            GizLogger.b("airlink_send_start_mxchip3", null, "start config MXCHIP3: ssid = " + ssid + ", key = " + key);
            GizLogger.d(TAG, "start config MXCHIP3: ssid = " + ssid + ", key = " + key);
            this.elapi = new EasyLinkAPI(context);
            this.elapi.startEasyLink(context, ssid, key);
        } else if (XPGWifiGAgentType.XPGWifiGAgentTypeBL == type) {
            GizLogger.b("airlink_send_start_bl", null, "start config BL: ssid = " + ssid + ", key = " + key);
            GizLogger.d(TAG, "start config BL: ssid = " + ssid + ", key = " + key);
        }
    }

    public void getCaptchaCode(String appSecret) {
        GizLogger.b("get_captcha_token_req", null, "get captcha: app_sceret = " + appSecret);
        GizLogger.d(TAG, "get captcha: app_sceret = " + appSecret);
        GWifiSDK.sharedInstance().GetCaptchaCode(appSecret);
    }

    public void requestSendVerifyCode(String phone) {
        GizLogger.b("old_get_phone_sms_req", null, "old get phone sms: phone = " + phone);
        GWifiSDK.sharedInstance().RequestSendVerifyCode(phone);
    }

    private String getLang() {
        if (mContext == null) {
            GizLogger.d(TAG, "the context is null, use the default lang: en");
            return "en";
        }
        Locale locale = XPGWifiSDK.mContext.getResources().getConfiguration().locale;
        String language = locale.getLanguage();
        String ret = "en";
        if (language.endsWith("zh")) {
            ret = "zh-cn";
        }
        return ret;
    }

    public void requestSendPhoneSMSCode(String token, String captchaId, String captchaCode, String phone) {
        String lang = this.getLang();
        GizLogger.b("get_sms_req", null, "get sms: phone = " + phone + ", lang = " + lang);
        GizLogger.d(TAG, "get sms: phone = " + phone + ", lang = " + lang);
        GWifiSDK.sharedInstance().RequestSendPhoneSMSCode(token, captchaId, captchaCode, phone, lang);
    }

    public void verifyPhoneSMSCode(String token, String phoneCode, String phone) {
        GizLogger.b("sms_verify_req ", null, "sms verify: phone = " + phone);
        GizLogger.d(TAG, "sms verify: phone = " + phone);
        GWifiSDK.sharedInstance().VerifyPhoneSMSCode(token, phoneCode, phone);
    }

    public void registerUser(String userName, String password) {
        String lang = this.getLang();
        GizLogger.b("user_register_req", null, "user register: username = " + userName + ", userType = normal" + ", lang = " + lang);
        GizLogger.d(TAG, "user register: username = " + userName + ", userType = normal" + ", lang = " + lang);
        GWifiSDK.sharedInstance().RegisterNormalUser(userName, password, lang);
    }

    public void registerUserByPhoneAndCode(String phone, String password, String code) {
        String lang = this.getLang();
        GizLogger.b("user_register_req", null, "user register: username = " + phone + ", userType = phone" + ", lang = " + lang);
        GizLogger.d(TAG, "user register: username = " + phone + ", userType = phone" + ", lang = " + lang);
        GWifiSDK.sharedInstance().RegisterPhoneUser(phone, password, code, lang);
    }

    public void registerUserByEmail(String email, String password) {
        String lang = this.getLang();
        GizLogger.b("user_register_req", null, "user register: username = " + email + ", userType = email" + ", lang = " + lang);
        GizLogger.d(TAG, "user register: username = " + email + ", userType = email" + ", lang = " + lang);
        GWifiSDK.sharedInstance().RegisterEmailUser(email, password, lang);
    }

    private String getPhoneID() {
        if (mContext == null) {
            GizLogger.d(TAG, "Please startWithAppID first!");
            return "";
        }
        return Settings.Secure.getString((ContentResolver)mContext.getContentResolver(), (String)"android_id");
    }

    public void userLoginAnonymous() {
        String lang = this.getLang();
        GizLogger.b("user_login_req", null, "user login: userType = anonymous, lang = " + lang);
        GizLogger.d(TAG, "user login: userType = anonymous, lang = " + lang);
        GWifiSDK.sharedInstance().RegisterAnonymousUser(this.getPhoneID(), lang);
    }

    public void userLoginWithUserName(String userName, String password) {
        String lang = this.getLang();
        GizLogger.b("user_login_req", null, "user login: username = " + userName + ", userType = normal, lang = " + lang);
        GizLogger.d(TAG, "user login: username = " + userName + ", userType = normal, lang = " + lang);
        GWifiSDK.sharedInstance().UserLogin(userName, password, lang);
    }

    public void userLoginWithThirdAccountType(XPGWifiThirdAccountType thirdAccountType, String uid, String token) {
        int accountType = 0;
        String lang = this.getLang();
        if (XPGWifiThirdAccountType.XPGWifiThirdAccountTypeBAIDU == thirdAccountType) {
            GizLogger.b("user_login_req", null, "user login: username = " + uid + ", userType = baidu, lang = " + lang);
            GizLogger.d(TAG, "user login: username = " + uid + ", userType = baidu, lang = " + lang);
            accountType = 0;
        } else if (XPGWifiThirdAccountType.XPGWifiThirdAccountTypeSINA == thirdAccountType) {
            GizLogger.b("user_login_req", null, "user login: username = " + uid + ", userType = sina, lang = " + lang);
            GizLogger.d(TAG, "user login: username = " + uid + ", userType = sina, lang = " + lang);
            accountType = 1;
        } else if (XPGWifiThirdAccountType.XPGWifiThirdAccountTypeQQ == thirdAccountType) {
            GizLogger.b("user_login_req", null, "user login: username = " + uid + ", userType = qq, lang = " + lang);
            GizLogger.d(TAG, "user login: username = " + uid + ", userType = qq, lang = " + lang);
            accountType = 2;
        } else {
            GizLogger.d("user_login_resp", "GWifiError_INVALID_PARAM");
            GizLogger.d(TAG, "ready to callback didUserLogin(): GWifiError_INVALID_PARAM");
            if (mListener != null) {
                mListener.didUserLogin(GWifiErrorCode.GWifiError_INVALID_PARAM.swigValue(), "GWifiError_INVALID_PARAM", null, null);
                GizLogger.d(TAG, "callback end didUserLogin()");
            } else {
                GizLogger.d(TAG, "cannot callback, sdk listener is null");
            }
            return;
        }
        GWifiSDK.sharedInstance().RegisterThirdAccountUser(accountType, uid, token, lang);
    }

    public void userLogout(String uid) {
        GWifiSDK.sharedInstance().UserLogout(uid);
    }

    public void transAnonymousUserToNormalUser(String token, String userName, String password) {
        GizLogger.b("anony_user_transfer_req", null, "anony user trans: username = " + userName + ", userType = normal");
        GizLogger.d(TAG, "anony user trans: username = " + userName + ", userType = normal");
        GWifiSDK.sharedInstance().TransAnonymousUserToNormalUser(token, userName, password);
    }

    public void transAnonymousUserToPhoneUser(String token, String userName, String password, String code) {
        GizLogger.b("anony_user_transfer_req", null, "anony user trans: username = " + userName + ", userType = phone");
        GizLogger.d(TAG, "anony user trans: username = " + userName + ", userType = phone");
        GWifiSDK.sharedInstance().TransAnonymousUserToPhoneUser(token, userName, password, code);
    }

    public void changeUserPassword(String token, String oldPassword, String newPassword) {
        GizLogger.b("change_password_req", null, "change user password: token = " + token);
        GizLogger.d(TAG, "change user password: token = " + token);
        GWifiSDK.sharedInstance().ChangeUserPassword(token, oldPassword, newPassword);
    }

    public void changeUserPasswordByCode(String phone, String code, String newPassword) {
        GizLogger.b("change_password_req", null, "change user password: phone = " + phone);
        GizLogger.d(TAG, "change user password: phone = " + phone);
        GWifiSDK.sharedInstance().changeUserPasswordWithCode(phone, code, newPassword);
    }

    public void changeUserPasswordByEmail(String email) {
        GizLogger.b("change_password_req", null, "change user password: email = " + email);
        GizLogger.d(TAG, "change user password: email = " + email);
        GWifiSDK.sharedInstance().changeUserPasswordWithEmail(email);
    }

    public void changeUserEmail(String token, String email) {
        GWifiSDK.sharedInstance().ChangeUserInfo(token, email, null, GWifiUserType.GWifiUserTypeEMAIL, null);
    }

    public void changeUserPhone(String token, String phone, String code) {
        GWifiSDK.sharedInstance().ChangeUserInfo(token, phone, code, GWifiUserType.GWifiUserTypePHONE, null);
    }

    public void changeUserInfo(String token, String username, String verifyCode, XPGUserAccountType userType, XPGUserInfo additionalInfo) {
        GizLogger.b("change_user_info_req", null, "change user info: token = " + token);
        GizLogger.d(TAG, "change user info: token = " + token);
        GWifiUserType mUserType = XPGUserAccountType.Phone == userType ? GWifiUserType.GWifiUserTypePHONE : (XPGUserAccountType.Email == userType ? GWifiUserType.GWifiUserTypeEMAIL : GWifiUserType.GWifiUserTypeUSERNAME);
        GUserInfo_st mAdditionalInfo = null;
        if (additionalInfo != null) {
            mAdditionalInfo = new GUserInfo_st();
            mAdditionalInfo.setLang(this.getLang());
            mAdditionalInfo.setName(additionalInfo.getName());
            mAdditionalInfo.setBirthday(additionalInfo.getBirthday());
            mAdditionalInfo.setRemark(additionalInfo.getRemark());
            mAdditionalInfo.setAddress(additionalInfo.getAddress());
            XPGUserGenderType mGender = additionalInfo.getGender();
            int gender = XPGUserGenderType.Male == mGender ? 0 : (XPGUserGenderType.Female == mGender ? 1 : 2);
            mAdditionalInfo.setGender(gender);
        }
        GWifiSDK.sharedInstance().ChangeUserInfo(token, username, verifyCode, mUserType, mAdditionalInfo);
    }

    public void getUserInfo(String token) {
        GizLogger.b("get_user_info_req", null, "get user info: token = " + token);
        GizLogger.d(TAG, "get user info: token = " + token);
        GWifiSDK.sharedInstance().GetUserInfo(token);
    }

    public void bindDevice(String uid, String token, String did, String passCode, String remark) {
        GizLogger.b("dev_bind_req", null, "device bind: did = " + did + ", token = " + token);
        GizLogger.d(TAG, "device bind: did = " + did + ", token = " + token);
        GWifiSDK.sharedInstance().BindDevice(uid, token, did, passCode, remark);
    }

    public void unbindDevice(String uid, String token, String did, String passCode) {
        GizLogger.b("dev_unbind_req", null, "device unbind: did = " + did + ", token = " + token);
        GizLogger.d(TAG, "device unbind: did = " + did + ", token = " + token);
        GWifiSDK.sharedInstance().UnbindDevice(uid, token, did, passCode);
    }

    public void getBoundDevices(String uid, String token, String ... specialProductKey) {
        GizLogger.b("get_bind_req", null, "get bind devices: token = " + token);
        GizLogger.d(TAG, "get bind devices: token = " + token);
        if (specialProductKey != null && specialProductKey.length > 0) {
            GWifiConfig.sharedInstance().EnableProductFilter(true);
            String[] stringArray = specialProductKey;
            int n = specialProductKey.length;
            int n2 = 0;
            while (n2 < n) {
                String productKey = stringArray[n2];
                GWifiConfig.sharedInstance().RegisterProductKey(productKey);
                ++n2;
            }
        } else {
            GWifiConfig.sharedInstance().EnableProductFilter(false);
        }
        GWifiSDK.sharedInstance().GetBoundDevices(uid, token);
    }

    public void getBoundDevices(String uid, String token, List<String> specialProductKey) {
        GizLogger.b("get_bind_req", null, "get bind devices: token = " + token);
        GizLogger.d(TAG, "get bind devices: token = " + token);
        if (specialProductKey != null && specialProductKey.size() > 0) {
            GWifiConfig.sharedInstance().EnableProductFilter(true);
            for (String productKey : specialProductKey) {
                GWifiConfig.sharedInstance().RegisterProductKey(productKey);
            }
        } else {
            GWifiConfig.sharedInstance().EnableProductFilter(false);
        }
        GWifiSDK.sharedInstance().GetBoundDevices(uid, token);
    }

    public void getGroups(String uid, String token, List<String> specialProductKey) {
        GizLogger.b("get_group_req", null, "get group: get, uid = " + uid + ", token = " + token);
        GizLogger.d(TAG, "get group: get. uid = " + uid + ", token = " + token);
        if (uid == null || uid.length() == 0 || token == null || token.length() == 0) {
            GizLogger.b("get_group_resp", "XPGWifiError_INVALID_PARAM", null);
            GizLogger.d(TAG, "ready to callback: didGetGroups(), no uid or token");
            if (mListener != null) {
                mListener.didGetGroups(-20, null);
                GizLogger.d(TAG, "callback end: didGetGroups()");
            } else {
                GizLogger.d(TAG, "can not callback, sdk listener is null");
            }
            return;
        }
        if (specialProductKey != null && specialProductKey.size() == 0) {
            GizLogger.b("get_group_resp", "XPGWifiError_INVALID_PARAM", null);
            GizLogger.d(TAG, "ready to callback: didGetGroups(), no uid or token");
            if (mListener != null) {
                mListener.didGetGroups(-20, null);
                GizLogger.d(TAG, "callback end: didGetGroups()");
            } else {
                GizLogger.d(TAG, "can not callback, sdk listener is null");
            }
            return;
        }
        try {
            ArrayList<XPGWifiGroup> groupList = new ArrayList<XPGWifiGroup>();
            JSONArray groupArray = XPGWifiGroup.getGroupConfigJson(uid);
            int i = 0;
            while (i < groupArray.length()) {
                String productKey = groupArray.getJSONObject(i).getString("productKey");
                if (specialProductKey == null || specialProductKey.contains(productKey)) {
                    JSONObject groupJson = groupArray.getJSONObject(i);
                    groupJson.put("uid", (Object)uid);
                    XPGWifiGroup group = new XPGWifiGroup(groupJson);
                    groupList.add(group);
                }
                ++i;
            }
            GizLogger.b("get_group_resp", "XPGWifiError_NONE", "get group result: groups_number = " + groupList.size());
            GizLogger.d(TAG, "ready to callback: didGetGroups(), XPGWifiError_NONE, groups_number = " + groupList.size());
            if (mListener != null) {
                mListener.didGetGroups(0, groupList);
                GizLogger.d(TAG, "callback end: didGetGroups()");
            } else {
                GizLogger.d(TAG, "can not callback, sdk listener is null");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getGroups(String uid, String token, String ... specialProductKey) {
        GizLogger.b("get_group_req", null, "get group: get, uid = " + uid + ", token = " + token);
        GizLogger.d(TAG, "get group: get. uid = " + uid + ", token = " + token);
        if (uid == null || uid.length() == 0 || token == null || token.length() == 0) {
            GizLogger.b("get_group_resp", "XPGWifiError_INVALID_PARAM", null);
            GizLogger.d(TAG, "ready to callback: didGetGroups(), no uid or token");
            if (mListener != null) {
                mListener.didGetGroups(-20, null);
                GizLogger.d(TAG, "callback end: didGetGroups()");
            } else {
                GizLogger.d(TAG, "can not callback, sdk listener is null");
            }
            return;
        }
        ArrayList<String> productKeys = new ArrayList<String>();
        if (specialProductKey != null && specialProductKey.length > 0) {
            String[] stringArray = specialProductKey;
            int n = specialProductKey.length;
            int n2 = 0;
            while (n2 < n) {
                String productKey = stringArray[n2];
                if (productKey == null || productKey.length() <= 0) {
                    productKeys.clear();
                    break;
                }
                productKeys.add(productKey);
                ++n2;
            }
        }
        if (specialProductKey != null && productKeys.size() == 0) {
            GizLogger.b("get_group_resp", "XPGWifiError_INVALID_PARAM", null);
            GizLogger.d(TAG, "ready to callback: didGetGroups(), no special productkeys");
            if (mListener != null) {
                mListener.didGetGroups(-20, null);
                GizLogger.d(TAG, "callback end: didGetGroups()");
            } else {
                GizLogger.d(TAG, "can not callback, sdk listener is null");
            }
            return;
        }
        try {
            ArrayList<XPGWifiGroup> groupList = new ArrayList<XPGWifiGroup>();
            JSONArray groupArray = XPGWifiGroup.getGroupConfigJson(uid);
            int i = 0;
            while (i < groupArray.length()) {
                String productKey = groupArray.getJSONObject(i).getString("productKey");
                if (specialProductKey == null || productKeys.contains(productKey)) {
                    JSONObject groupJson = groupArray.getJSONObject(i);
                    groupJson.put("uid", (Object)uid);
                    XPGWifiGroup group = new XPGWifiGroup(groupJson);
                    groupList.add(group);
                }
                ++i;
            }
            GizLogger.b("get_group_resp", "XPGWifiError_NONE", "get group result: groups_number = " + groupList.size());
            GizLogger.d(TAG, "ready to callback: didGetGroups(), XPGWifiError_NONE, get group result: groups_number = " + groupList.size());
            if (mListener != null) {
                mListener.didGetGroups(0, groupList);
                GizLogger.d(TAG, "callback end: didGetGroups()");
            } else {
                GizLogger.d(TAG, "can not callback, sdk listener is null");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addGroup(String uid, String token, String productKey, String groupName, List<ConcurrentHashMap<String, String>> specialDevices) {
        GizLogger.b("get_group_req", null, "get group: add. uid = " + uid + ", token = " + token);
        GizLogger.d(TAG, "get group: add. uid = " + uid + ", token = " + token);
        if (uid == null || uid.length() == 0 || token == null || token.length() == 0 || productKey == null || productKey.length() == 0 || groupName == null || groupName.length() == 0) {
            GizLogger.b("get_group_resp", "XPGWifiError_INVALID_PARAM", null);
            GizLogger.d(TAG, "ready to callback: didGetGroups(), no uid or token or ...");
            if (mListener != null) {
                mListener.didGetGroups(-20, null);
                GizLogger.d(TAG, "callback end: didGetGroups()");
            } else {
                GizLogger.d(TAG, "can not callback, sdk listener is null");
            }
            return;
        }
        try {
            String gid = null;
            JSONArray groupArray = XPGWifiGroup.getGroupConfigJson(uid);
            if (groupArray.length() == 0) {
                groupArray = new JSONArray();
                gid = "0";
            } else {
                gid = String.valueOf(Integer.valueOf(groupArray.getJSONObject(groupArray.length() - 1).getString("gid")) + 1);
            }
            JSONArray devices = new JSONArray();
            if (specialDevices != null) {
                for (ConcurrentHashMap<String, String> deviceMap : specialDevices) {
                    if (!deviceMap.containsKey("did") || !deviceMap.containsKey("sdid")) continue;
                    JSONObject device = new JSONObject();
                    device.put("did", (Object)deviceMap.get("did"));
                    device.put("sdid", (Object)deviceMap.get("sdid"));
                    devices.put((Object)device);
                }
            }
            JSONObject groupJson = new JSONObject();
            groupJson.put("gid", (Object)gid);
            groupJson.put("productKey", (Object)productKey);
            groupJson.put("groupName", (Object)groupName);
            groupJson.put("devices", (Object)devices);
            groupArray.put((Object)groupJson);
            XPGWifiGroup.writeToFile(groupArray.toString(), XPGWifiGroup.getGroupConfigFilePath(uid));
            ArrayList<XPGWifiGroup> groupList = new ArrayList<XPGWifiGroup>();
            int i = 0;
            while (i < groupArray.length()) {
                groupJson = groupArray.getJSONObject(i);
                groupJson.put("uid", (Object)uid);
                XPGWifiGroup group = new XPGWifiGroup(groupJson);
                groupList.add(group);
                ++i;
            }
            GizLogger.b("get_group_resp", "XPGWifiError_NONE", "get group result: groups_number = " + groupList.size());
            GizLogger.d(TAG, "ready to callback: didGetGroups(), XPGWifiError_NONE, get group result: groups_number = " + groupList.size());
            if (mListener != null) {
                GizLogger.d(TAG, "ready to callback: didGetGroups(), XPGWifiError_NONE");
                mListener.didGetGroups(0, groupList);
                GizLogger.d(TAG, "callback end: didGetGroups()");
            } else {
                GizLogger.d(TAG, "can not callback, sdk listener is null");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void removeGroup(String uid, String token, String gid) {
        GizLogger.b("get_group_req", null, "get group: remove. uid = " + uid + ", token = " + token);
        GizLogger.d(TAG, "get group: remove. uid = " + uid + ", token = " + token);
        if (uid == null || uid.length() == 0 || token == null || token.length() == 0 || gid == null || gid.length() == 0) {
            GizLogger.b("get_group_resp", "XPGWifiError_INVALID_PARAM", null);
            GizLogger.d(TAG, "ready to callback: didGetGroups(), no uid or token or ...");
            if (mListener != null) {
                mListener.didGetGroups(-20, null);
                GizLogger.d(TAG, "callback end: didGetGroups()");
            } else {
                GizLogger.d(TAG, "can not callback, sdk listener is null");
            }
            return;
        }
        try {
            JSONArray groupArray = XPGWifiGroup.getGroupConfigJson(uid);
            int i = 0;
            while (i < groupArray.length()) {
                if (groupArray.getJSONObject(i).getString("gid").equals(gid)) {
                    groupArray = XPGWifiGroup.removeJSONArray(groupArray, i);
                    XPGWifiGroup.writeToFile(groupArray.toString(), XPGWifiGroup.getGroupConfigFilePath(uid));
                    ArrayList<XPGWifiGroup> groupList = new ArrayList<XPGWifiGroup>();
                    i = 0;
                    while (i < groupArray.length()) {
                        JSONObject groupJson = groupArray.getJSONObject(i);
                        groupJson.put("uid", (Object)uid);
                        XPGWifiGroup group = new XPGWifiGroup(groupJson);
                        groupList.add(group);
                        ++i;
                    }
                    GizLogger.b("get_group_resp", "XPGWifiError_NONE", "get group result: groups_number = " + groupList.size());
                    GizLogger.d(TAG, "ready to callback: didGetGroups(), XPGWifiError_NONE, get group result: groups_number = " + groupList.size());
                    if (mListener != null) {
                        mListener.didGetGroups(0, groupList);
                        GizLogger.d(TAG, "callback end: didGetGroups()");
                    } else {
                        GizLogger.d(TAG, "can not callback, sdk listener is null");
                    }
                }
                ++i;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void editGroup(String uid, String token, String gid, String groupName, List<ConcurrentHashMap<String, String>> specialDevices) {
        GizLogger.b("get_group_req", null, "get group: edit. uid = " + uid + ", token = " + token);
        GizLogger.d(TAG, "get group: edit. uid = " + uid + ", token = " + token);
        if (uid == null || uid.length() == 0 || token == null || token.length() == 0 || gid == null || gid.length() == 0 || token.length() == 0 || groupName == null || groupName.length() == 0) {
            GizLogger.b("get_group_resp", "XPGWifiError_INVALID_PARAM", null);
            GizLogger.d(TAG, "ready to callback: didGetGroups(), no uid or token or ...");
            if (mListener != null) {
                mListener.didGetGroups(-20, null);
                GizLogger.d(TAG, "callback end: didGetGroups()");
            } else {
                GizLogger.d(TAG, "can not callback, sdk listener is null");
            }
            return;
        }
        try {
            JSONArray groupArray = XPGWifiGroup.getGroupConfigJson(uid);
            int i = 0;
            while (i < groupArray.length()) {
                if (groupArray.getJSONObject(i).getString("gid").equals(gid)) {
                    JSONObject groupJson = groupArray.getJSONObject(i);
                    groupJson.put("groupName", (Object)groupName);
                    groupArray.put(i, (Object)groupArray);
                    JSONArray devices = new JSONArray();
                    if (specialDevices != null) {
                        for (ConcurrentHashMap<String, String> deviceMap : specialDevices) {
                            if (!deviceMap.containsKey("did") || !deviceMap.containsKey("sdid")) continue;
                            JSONObject device = new JSONObject();
                            device.put("did", (Object)deviceMap.get("did"));
                            device.put("sdid", (Object)deviceMap.get("sdid"));
                            devices.put((Object)device);
                        }
                    }
                    groupJson.put("devices", (Object)devices);
                    groupArray.put(i, (Object)groupJson);
                    XPGWifiGroup.writeToFile(groupArray.toString(), XPGWifiGroup.getGroupConfigFilePath(uid));
                    ArrayList<XPGWifiGroup> groupList = new ArrayList<XPGWifiGroup>();
                    i = 0;
                    while (i < groupArray.length()) {
                        groupJson = groupArray.getJSONObject(i);
                        groupJson.put("uid", (Object)uid);
                        XPGWifiGroup group = new XPGWifiGroup(groupJson);
                        groupList.add(group);
                        ++i;
                    }
                    GizLogger.b("get_group_resp", "XPGWifiError_NONE", "get group result: groups_number = " + groupList.size());
                    GizLogger.d(TAG, "ready to callback: didGetGroups(), XPGWifiError_NONE, groups_number = " + groupList.size());
                    if (mListener != null) {
                        mListener.didGetGroups(0, groupList);
                        GizLogger.d(TAG, "callback end: didGetGroups()");
                    } else {
                        GizLogger.d(TAG, "can not callback, sdk listener is null");
                    }
                }
                ++i;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static enum GizLogPrintLevel {
        GizLogPrintNone,
        GizLogPrintI,
        GizLogPrintII,
        GizLogPrintAll;

    }

    public static enum XPGUserAccountType {
        Normal,
        Phone,
        Email;

    }

    public static enum XPGUserGenderType {
        Male,
        Female,
        Unknown;

    }

    public static enum XPGWifiConfigureMode {
        XPGWifiConfigureModeSoftAP,
        XPGWifiConfigureModeAirLink;

    }

    public static enum XPGWifiGAgentType {
        XPGWifiGAgentTypeMXCHIP,
        XPGWifiGAgentTypeHF,
        XPGWifiGAgentTypeRTK,
        XPGWifiGAgentTypeWM,
        XPGWifiGAgentTypeESP,
        XPGWifiGAgentTypeQCA,
        XPGWifiGAgentTypeTI,
        XPGWifiGAgentTypeFSK,
        XPGWifiGAgentTypeMXCHIP3,
        XPGWifiGAgentTypeBL;

    }

    public static enum XPGWifiLogLevel {
        XPGWifiLogLevelError,
        XPGWifiLogLevelWarning,
        XPGWifiLogLevelAll;

    }

    public static enum XPGWifiThirdAccountType {
        XPGWifiThirdAccountTypeBAIDU,
        XPGWifiThirdAccountTypeSINA,
        XPGWifiThirdAccountTypeQQ;

    }
}

