/*
 * Decompiled with CFR 0.152.
 */
package com.xtremeprog.xpgconnect.smartlink.v3;

import android.content.Context;
import android.net.DhcpInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import com.xtremeprog.xpgconnect.smartlink.ISmartLinker;
import com.xtremeprog.xpgconnect.smartlink.OnSmartLinkListener;
import com.xtremeprog.xpgconnect.smartlink.SmartLinkedModule;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;

public class SnifferSmartLinker
implements ISmartLinker {
    private String TAG = "HFdebug";
    private String ssid;
    private String pswd;
    private String broadCastIP;
    private String gateWay;
    private static SnifferSmartLinker me = null;
    private Set<String> successMacSet = new HashSet<String>();
    private int HEADER_COUNT = 200;
    private int HEADER_PACKAGE_DELAY_TIME = 10;
    private int HEADER_CAPACITY = 76;
    private OnSmartLinkListener callback;
    private int CONTENT_COUNT = 5;
    private int CONTENT_PACKAGE_DELAY_TIME = 50;
    private int CONTENT_CHECKSUM_BEFORE_DELAY_TIME = 100;
    private int CONTENT_GROUP_DELAY_TIME = 500;
    private final String RET_KEY = "smart_config";
    private int port = 49999;
    private byte[] receiveByte = new byte[512];
    public static final int DEVICE_COUNT_ONE = 1;
    public static final int DEVICE_COUNT_MULTIPLE = -1;
    private boolean isConnecting = false;
    private InetAddress inetAddressbroadcast;
    private DatagramSocket socket;
    private DatagramPacket packetToSendbroadcast;
    private DatagramPacket packetToSendgateway;
    private DatagramPacket dataPacket;
    private boolean isfinding = false;
    private Runnable findThread = new Runnable(){

        @Override
        public void run() {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Log.i((String)SnifferSmartLinker.this.TAG, (String)"run() sleep 1: InterruptedException");
            }
            int i = 0;
            while (i < 20 && SnifferSmartLinker.this.isConnecting) {
                SnifferSmartLinker.this.sendFindCmd();
                if (SnifferSmartLinker.this.isConnecting) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Log.i((String)SnifferSmartLinker.this.TAG, (String)"run() sleep 2: InterruptedException");
                    }
                }
                ++i;
            }
            if (SnifferSmartLinker.this.isConnecting && SnifferSmartLinker.this.callback != null) {
                if (SnifferSmartLinker.this.successMacSet.size() <= 0) {
                    SnifferSmartLinker.this.callback.onTimeOut();
                } else if (SnifferSmartLinker.this.successMacSet.size() > 0) {
                    SnifferSmartLinker.this.callback.onCompleted();
                }
            }
            Log.e((String)SnifferSmartLinker.this.TAG, (String)"stop find");
            SnifferSmartLinker.this.isfinding = false;
            SnifferSmartLinker.this.stop();
        }
    };

    private SnifferSmartLinker() {
    }

    public static SnifferSmartLinker getInstence() {
        return SnifferSmartLinkerInner.SNIFFER_SMART_LINKER;
    }

    private String getBroadcastAddress(Context ctx) {
        WifiManager cm = (WifiManager)ctx.getSystemService("wifi");
        DhcpInfo myDhcpInfo = cm.getDhcpInfo();
        if (myDhcpInfo == null) {
            return "255.255.255.255";
        }
        int broadcast = myDhcpInfo.ipAddress & myDhcpInfo.netmask | ~myDhcpInfo.netmask;
        byte[] quads = new byte[4];
        int k = 0;
        while (k < 4) {
            quads[k] = (byte)(broadcast >> k * 8 & 0xFF);
            ++k;
        }
        try {
            return InetAddress.getByAddress(quads).getHostAddress();
        }
        catch (Exception e) {
            return "255.255.255.255";
        }
    }

    private void connect() {
        Log.e((String)this.TAG, (String)"connect");
        int count = 1;
        byte[] header = this.getBytes(this.HEADER_CAPACITY);
        while (count <= this.HEADER_COUNT && this.isConnecting) {
            this.send(header);
            try {
                Thread.sleep(this.HEADER_PACKAGE_DELAY_TIME);
            }
            catch (InterruptedException e) {
                Log.i((String)this.TAG, (String)"connect(): InterruptedException");
            }
            ++count;
        }
        String pwd = this.pswd;
        int[] content = new int[pwd.length() + 2];
        content[0] = 89;
        int j = 1;
        int i = 0;
        while (i < pwd.length()) {
            content[j] = pwd.charAt(i) + 76;
            ++j;
            ++i;
        }
        content[content.length - 1] = 86;
        count = 1;
        while (count <= this.CONTENT_COUNT && this.isConnecting) {
            i = 0;
            while (i < content.length) {
                int _count = 1;
                if (i == 0 || i == content.length - 1) {
                    _count = 3;
                }
                int t = 1;
                while (t <= _count && this.isConnecting) {
                    this.send(this.getBytes(content[i]));
                    if (i != content.length) {
                        try {
                            Thread.sleep(this.CONTENT_PACKAGE_DELAY_TIME);
                        }
                        catch (InterruptedException e) {
                            Log.i((String)this.TAG, (String)"connect() send: InterruptedException");
                        }
                    }
                    ++t;
                }
                if (i != content.length) {
                    try {
                        Thread.sleep(this.CONTENT_PACKAGE_DELAY_TIME);
                    }
                    catch (InterruptedException e) {
                        Log.i((String)this.TAG, (String)"connect() sleep 1: InterruptedException");
                    }
                }
                ++i;
            }
            try {
                Thread.sleep(this.CONTENT_CHECKSUM_BEFORE_DELAY_TIME);
            }
            catch (InterruptedException e) {
                Log.i((String)this.TAG, (String)"connect() sleep 2: InterruptedException");
            }
            int checkLength = pwd.length() + 256 + 76;
            int t = 1;
            while (t <= 3 && this.isConnecting) {
                this.send(this.getBytes(checkLength));
                if (t < 3) {
                    try {
                        Thread.sleep(this.CONTENT_PACKAGE_DELAY_TIME);
                    }
                    catch (InterruptedException e) {
                        Log.i((String)this.TAG, (String)"connect() sleep 3: InterruptedException");
                    }
                }
                ++t;
            }
            try {
                Thread.sleep(this.CONTENT_GROUP_DELAY_TIME);
            }
            catch (InterruptedException e) {
                Log.i((String)this.TAG, (String)"connect() sleep 4: InterruptedException");
            }
            ++count;
        }
        Log.e((String)this.TAG, (String)"connect END");
    }

    private byte[] getBytes(int capacity) {
        byte[] data = new byte[capacity];
        int i = 0;
        while (i < capacity) {
            data[i] = 5;
            ++i;
        }
        return data;
    }

    private char byteToChar(byte[] b) {
        char c = (char)((b[0] & 0xFF) << 8 | b[1] & 0xFF);
        return c;
    }

    private void sendFindCmd() {
        System.out.println("smartlinkfind");
        this.packetToSendbroadcast = new DatagramPacket("smartlinkfind".getBytes(), "smartlinkfind".getBytes().length, this.inetAddressbroadcast, 48899);
        try {
            this.socket.send(this.packetToSendbroadcast);
        }
        catch (IOException e) {
            Log.i((String)this.TAG, (String)"sendFindCmd(): IOException");
        }
    }

    private void sendHFA11Cmd() {
        System.out.println("smartlinkfind");
        this.packetToSendbroadcast = new DatagramPacket("HF-A11ASSISTHREAD".getBytes(), "HF-A11ASSISTHREAD".getBytes().length, this.inetAddressbroadcast, 48899);
        try {
            this.socket.send(this.packetToSendbroadcast);
        }
        catch (IOException e) {
            Log.i((String)this.TAG, (String)"sendHFA11Cmd(): IOException");
        }
    }

    private void send(byte[] data) {
        this.packetToSendbroadcast = new DatagramPacket(data, data.length, this.inetAddressbroadcast, this.port);
        try {
            this.socket.send(this.packetToSendbroadcast);
        }
        catch (IOException e) {
            Log.i((String)this.TAG, (String)"send(): IOException");
        }
    }

    private void receive() {
        Log.e((String)this.TAG, (String)"start RECV");
        this.dataPacket = new DatagramPacket(this.receiveByte, this.receiveByte.length);
        new Thread(){

            @Override
            public void run() {
                while (SnifferSmartLinker.this.isConnecting) {
                    try {
                        String receiveStr;
                        SnifferSmartLinker.this.socket.receive(SnifferSmartLinker.this.dataPacket);
                        int len = SnifferSmartLinker.this.dataPacket.getLength();
                        if (len <= 0 || !(receiveStr = new String(SnifferSmartLinker.this.receiveByte, 0, len, "UTF-8")).contains("smart_config")) continue;
                        Log.e((String)"RECV", (String)"smart_config");
                        SmartLinkedModule mi = new SmartLinkedModule();
                        mi.setMac(receiveStr.replace("smart_config", "").trim());
                        String ip = SnifferSmartLinker.this.dataPacket.getAddress().getHostAddress();
                        if (ip.equalsIgnoreCase("0.0.0.0") || ip.contains(":")) {
                            return;
                        }
                        mi.setModuleIP(ip);
                        if (SnifferSmartLinker.this.successMacSet.contains(mi.getMac())) continue;
                        SnifferSmartLinker.this.successMacSet.add(mi.getMac());
                        if (SnifferSmartLinker.this.callback == null) continue;
                        SnifferSmartLinker.this.callback.onLinked(mi);
                    }
                    catch (IOException e) {
                        Log.i((String)SnifferSmartLinker.this.TAG, (String)"receive(): IOException");
                    }
                }
                Log.e((String)SnifferSmartLinker.this.TAG, (String)"end RECV");
                SnifferSmartLinker.this.stop();
            }
        }.start();
    }

    @Override
    public void setOnSmartLinkListener(OnSmartLinkListener listener) {
        this.callback = listener;
    }

    @Override
    public void start(Context context, String password, String ... ssid) throws Exception {
        Log.e((String)this.TAG, (String)(ssid + ":" + password));
        this.ssid = ssid != null && ssid.length > 0 ? ssid[0] : null;
        this.pswd = password;
        this.broadCastIP = this.getBroadcastAddress(context);
        this.socket = new DatagramSocket(this.port);
        this.socket.setBroadcast(true);
        this.inetAddressbroadcast = InetAddress.getByName(this.broadCastIP);
        Log.e((String)this.TAG, (String)"start");
        this.isConnecting = true;
        this.receive();
        this.successMacSet.clear();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (SnifferSmartLinker.this.isConnecting) {
                    SnifferSmartLinker.this.connect();
                }
                Log.e((String)SnifferSmartLinker.this.TAG, (String)"StopConnet");
                SnifferSmartLinker.this.stop();
            }
        }).start();
        if (!this.isfinding) {
            this.isfinding = true;
            new Thread(this.findThread).start();
        }
    }

    @Override
    public void stop() {
        this.isConnecting = false;
        if (this.socket != null) {
            this.socket.close();
        }
    }

    @Override
    public boolean isSmartLinking() {
        return this.isConnecting;
    }

    /* synthetic */ SnifferSmartLinker(SnifferSmartLinker snifferSmartLinker) {
        this();
    }

    private static class SnifferSmartLinkerInner {
        private static final SnifferSmartLinker SNIFFER_SMART_LINKER = new SnifferSmartLinker(null);

        private SnifferSmartLinkerInner() {
        }
    }
}

