/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.easylink;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import com.mxchip.easylink_plus.EasyLink_plus;
import java.net.NetworkInterface;
import java.net.SocketException;

public class EasyLinkAPI {
    public static final String TAG = "---------EasylinkAPI---------";
    private final Context mContext;
    private WifiManager mWifiManager;
    private WifiInfo mWifiInfo;
    private EasyLink_plus mEasylinkPlus;
    private Context ctx;
    private boolean eltag = false;

    public EasyLinkAPI(Context context) {
        this.mContext = context;
    }

    public String getSSID() {
        this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        return this.mWifiInfo.getSSID().replaceAll("\"", "");
    }

    public void startEasyLink(Context context, String ssid, String password) {
        if (!this.eltag) {
            try {
                Log.d((String)TAG, (String)"we will start easylink------------------->");
                this.startEasylink(context, ssid, password);
                this.eltag = true;
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)e.getMessage());
            }
        } else {
            Log.d((String)TAG, (String)"easylink is working------------------->");
        }
    }

    public void stopEasyLink() {
        if (this.mEasylinkPlus != null && this.eltag) {
            Log.d((String)TAG, (String)"we will close easylink------------------->");
            this.mEasylinkPlus = EasyLink_plus.getInstence(this.ctx);
            this.mEasylinkPlus.stopTransmitting();
            this.eltag = false;
        } else {
            Log.d((String)TAG, (String)"easylink is closed------------------->");
        }
    }

    protected void startEasylink(Context context, String ssid, String password) {
        int ip = this.getNormalIP();
        this.ctx = context;
        this.mEasylinkPlus = EasyLink_plus.getInstence(context);
        try {
            NetworkInterface intf = NetworkInterface.getByName("wlan0");
            if (intf.getMTU() < 1500) {
                this.mEasylinkPlus.setSmallMtu(true);
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        try {
            this.mEasylinkPlus.transmitSettings(ssid, password, ip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getNormalIP() {
        this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        return this.mWifiInfo.getIpAddress();
    }
}

