/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.easylink_v3;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class EasyLink_v3 {
    private static int START_FLAG1 = 1450;
    private static int START_FLAG2 = 1451;
    private static int START_FLAG3 = 1452;
    private static int UDP_START_PORT = 50000;
    private static boolean stopSending;
    private byte[] key = new byte[65];
    private byte[] ssid = new byte[65];
    private byte[] user_info = new byte[65];
    private static byte[] send_data;
    private static byte[] buffer;
    private static int len;
    private InetAddress address = null;
    private DatagramPacket send_packet = null;
    private int port = 0;
    private static EasyLink_v3 e3;
    private boolean small_mtu;

    static {
        send_data = new byte[128];
        buffer = new byte[1500];
    }

    private EasyLink_v3() {
        stopSending = false;
    }

    public static EasyLink_v3 getInstence() {
        if (e3 == null) {
            e3 = new EasyLink_v3();
        }
        return e3;
    }

    public void transmitSettings(byte[] Ssid, byte[] Key, byte[] Userinfo) {
        try {
            this.address = InetAddress.getByName("255.255.255.255");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ssid = Ssid;
        this.key = Key;
        this.user_info = Userinfo;
        int i = 0;
        int checksum = 0;
        EasyLink_v3.send_data[i++] = (byte)(3 + this.ssid.length + this.key.length + this.user_info.length + 2);
        EasyLink_v3.send_data[i++] = (byte)this.ssid.length;
        EasyLink_v3.send_data[i++] = (byte)this.key.length;
        int j = 0;
        while (j < this.ssid.length) {
            EasyLink_v3.send_data[i] = this.ssid[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < this.key.length) {
            EasyLink_v3.send_data[i] = this.key[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < this.user_info.length) {
            EasyLink_v3.send_data[i] = this.user_info[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < i) {
            checksum = (short)(checksum + (send_data[j] & 0xFF));
            ++j;
        }
        EasyLink_v3.send_data[i++] = (byte)((checksum & 0xFFFF) >> 8);
        EasyLink_v3.send_data[i++] = (byte)(checksum & 0xFF);
        new Thread(new Runnable(){

            @Override
            public void run() {
                stopSending = false;
                EasyLink_v3.this.send();
            }
        }).start();
    }

    private void send() {
        while (!stopSending) {
            try {
                this.port = UDP_START_PORT;
                int k = 0;
                this.UDP_SEND(START_FLAG1);
                this.UDP_SEND(START_FLAG2);
                this.UDP_SEND(START_FLAG3);
                int i = 0;
                int j = 1;
                while (i < send_data[0]) {
                    len = j * 256 + (send_data[i] & 0xFF);
                    this.UDP_SEND(len);
                    if (i % 4 == 3) {
                        len = 1280 + ++k;
                        this.UDP_SEND(len);
                    }
                    if (++j == 5) {
                        j = 1;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void SetSmallMTU(boolean onoff) {
        this.small_mtu = onoff;
    }

    private void UDP_SEND(int length) {
        try {
            DatagramSocket udpSocket = new DatagramSocket();
            udpSocket.setBroadcast(true);
            if (this.small_mtu) {
                if (length > 1280) {
                    length -= 1280;
                }
                if (length < 64) {
                    length += 176;
                }
            }
            this.send_packet = new DatagramPacket(buffer, length, this.address, this.port);
            udpSocket.send(this.send_packet);
            Thread.sleep(10L);
            udpSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopTransmitting() {
        stopSending = true;
    }
}

