/*
 * Decompiled with CFR 0.152.
 */
package com.realtek.simpleconfiglib;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import com.realtek.simpleconfiglib.SCNetworkOps;
import com.realtek.simpleconfiglib.SCParam;
import com.realtek.simpleconfiglib.SCPattern;
import com.realtek.simpleconfiglib.SCPatternBase;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class SCLibrary {
    private static final String TAG = "SCLibrary";
    private SCPatternBase SCPattern;
    private Thread SendThread;
    private Thread RecvThread;
    private boolean SendEnable;
    private boolean RecvEnable;
    private SCNetworkOps SCNetOps;
    public Handler TreadMsgHandler;
    public static int ProfileSendTimeMillis = 120000;
    public static int ProfileSendTimeIntervalMs = 0;
    public static int EachPacketSendCounts = 1;
    public static int PacketSendTimeIntervalMs = 0;
    public static final int SyncRandomNum = 4;
    public static byte[] SyncRandomData = new byte[4];

    private byte[] int2byte(int in) {
        byte[] out = new byte[]{(byte)(in & 0xFF), (byte)(in >> 8 & 0xFF), (byte)(in >> 16 & 0xFF), (byte)(in >> 24 & 0xFF)};
        return out;
    }

    public void WifiInit(Context context) {
        this.SCNetOps.WifiInit(context);
    }

    public void WifiOpen() {
        this.SCNetOps.WifiOpen();
    }

    public void WifiStartScan() {
        this.SCNetOps.WifiStartScan();
    }

    public List<ScanResult> WifiGetScanResults() {
        return this.SCNetOps.WifiGetScanResults();
    }

    public int WifiStatus() {
        return this.SCNetOps.WifiStatus();
    }

    public String WifiAvailable() {
        return this.SCNetOps.WifiAvailable();
    }

    public boolean isWifiConnected(String ssid) {
        return this.SCNetOps.isWifiConnected(ssid);
    }

    public String getConnectedWifiSSID() {
        return this.SCNetOps.getConnectedWifiSSID();
    }

    public String WifiGetMacStr() {
        return this.SCNetOps.WifiGetMacStr();
    }

    public int WifiGetIpInt() {
        return this.SCNetOps.WifiGetIpInt();
    }

    private byte[] SCAddTLV(byte[] data, byte id, int len, byte[] val, int[] ret_len) {
        byte[] size = new byte[1];
        byte[] tag = new byte[1];
        size[0] = (byte)len;
        tag[0] = id;
        try {
            System.arraycopy(tag, 0, data, ret_len[0] + 0, 1);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Array copy tag error!");
            e.printStackTrace();
            return null;
        }
        try {
            System.arraycopy(size, 0, data, ret_len[0] + 1, 1);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Array copy size error!");
            e.printStackTrace();
            return null;
        }
        try {
            System.arraycopy(val, 0, data, ret_len[0] + 2, len);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Array copy val error!");
            e.printStackTrace();
            return null;
        }
        return data;
    }

    private byte[] SCProfileAddSSID(byte[] outbuf, int total_len, int[] ret_len, byte[] ssid) {
        if (ret_len[0] + 2 + ssid.length > total_len) {
            return null;
        }
        outbuf = this.SCAddTLV(outbuf, (byte)1, ssid.length, ssid, ret_len);
        ret_len[0] = ret_len[0] + (2 + ssid.length);
        return outbuf;
    }

    private byte[] SCProfileAddPasswd(byte[] outbuf, int total_len, int[] ret_len, byte[] key) {
        if (ret_len[0] + 2 + key.length > total_len) {
            return null;
        }
        outbuf = this.SCAddTLV(outbuf, (byte)2, key.length, key, ret_len);
        ret_len[0] = ret_len[0] + (2 + key.length);
        return outbuf;
    }

    private byte[] SCProfileAddIP(byte[] outbuf, int total_len, int[] ret_len, int ip) {
        byte[] ipTmp = this.int2byte(ip);
        if (ret_len[0] + 2 + ipTmp.length > total_len) {
            return null;
        }
        outbuf = this.SCAddTLV(outbuf, (byte)3, ipTmp.length, ipTmp, ret_len);
        ret_len[0] = ret_len[0] + 6;
        return outbuf;
    }

    private void SendSync() {
        this.SCPattern.SendSync();
    }

    private void SendEnd() {
        this.SCPattern.SendEnd();
    }

    private void SendData() {
        this.SCPattern.SendData();
    }

    private boolean RecvData() {
        return this.SCPattern.RecvData();
    }

    private void GenerateKey() {
        this.SCPattern.GenerateKey();
    }

    private void EncryptProfile() {
        this.SCPattern.EncryptProfile();
    }

    private int RtkSCNetInit() {
        this.SCNetOps = new SCNetworkOps();
        this.SCPattern = new SCPattern();
        SCParam.UDPBcast.SrcPort = 18864;
        SCParam.UDPBcast.DestPort = 18864;
        this.SCNetOps.BcastSocketCreate();
        SCParam.UDPMcast.SrcPort = 8863;
        SCParam.UDPMcast.DestPort = 18864;
        this.SCNetOps.McastSocketCreate();
        SCParam.UDPUcast.SrcPort = 8864;
        SCParam.UDPUcast.DestPort = 8864;
        this.SCNetOps.UnicastSocketCreate();
        return 0;
    }

    public void rtk_sc_reset() {
        SCParam.RtkSC.PlainTotalLen = 256;
        Arrays.fill(SCParam.RtkSC.PlainBuf, (byte)0);
        SCParam.RtkSC.PlainCurrent = SCParam.RtkSC.PlainBuf;
        SCParam.RtkSC.PlainCurrentLen[0] = 0;
        SCParam.RecvACK.MaxCfgNum = 0;
        Arrays.fill(SCParam.RecvACK.Status, (byte)0);
        int i = 0;
        while (i < 32) {
            Arrays.fill(SCParam.RecvACK.Mac[i], (byte)0);
            Arrays.fill(SCParam.RecvACK.Type[i], (byte)0);
            Arrays.fill(SCParam.RecvACK.IPBuf[i], (byte)0);
            Arrays.fill(SCParam.RecvACK.NameBuf[i], (byte)0);
            ++i;
        }
        SCParam.RecvACK.IP = new String[32];
        SCParam.RecvACK.Name = new String[32];
        this.SCPattern.PatternSet();
    }

    public void rtk_sc_init() {
        this.RtkSCNetInit();
        this.rtk_sc_reset();
        this.RtkSCRecvThread();
    }

    public void rtk_sc_exit() {
        this.SCNetOps.BcastSocketDestroy();
        this.SCNetOps.McastSocketDestroy();
        this.SCNetOps.UnicastSocketDestroy();
        this.SendEnable = false;
        this.RecvEnable = false;
        this.RecvThread.interrupt();
    }

    public void rtk_sc_set_ssid(String ssid) {
        if (ssid == null) {
            return;
        }
        byte[] ret = this.SCProfileAddSSID(SCParam.RtkSC.PlainCurrent, SCParam.RtkSC.PlainTotalLen, SCParam.RtkSC.PlainCurrentLen, ssid.getBytes());
        if (ret == null) {
            Log.e((String)TAG, (String)"SSID is null\n");
        }
    }

    public void rtk_sc_set_password(String key) {
        if (key == null) {
            return;
        }
        byte[] ret = this.SCProfileAddPasswd(SCParam.RtkSC.PlainCurrent, SCParam.RtkSC.PlainTotalLen, SCParam.RtkSC.PlainCurrentLen, key.getBytes());
        if (ret == null) {
            Log.e((String)TAG, (String)"Password is null\n");
        }
    }

    public void rtk_sc_set_default_pin(String pin) {
        if (pin != null && pin.length() > 0) {
            this.SCPattern.Default_PIN = pin;
        } else {
            Log.e((String)TAG, (String)"Invalid PIN");
        }
    }

    public String rtk_sc_get_default_pin() {
        return this.SCPattern.Default_PIN;
    }

    public void rtk_sc_set_pin(String pin) {
        if (pin != null && pin.length() > 0) {
            this.SCPattern.Index = 3;
            this.SCPattern.Local_PIN = pin;
        } else {
            this.SCPattern.Index = 2;
            this.SCPattern.Local_PIN = this.SCPattern.Default_PIN;
        }
    }

    public void rtk_sc_set_ip(int ip) {
        byte[] ret = this.SCProfileAddIP(SCParam.RtkSC.PlainCurrent, SCParam.RtkSC.PlainTotalLen, SCParam.RtkSC.PlainCurrentLen, ip);
        if (ret == null) {
            Log.e((String)TAG, (String)"IP is null\n");
        }
    }

    public void rtk_sc_gen_random() {
        int i = 0;
        while (i < 4) {
            byte i2;
            Random r = new Random();
            int i1 = r.nextInt(256);
            SCLibrary.SyncRandomData[i] = i2 = (byte)(i1 & 0xFF);
            ++i;
        }
    }

    public void rtk_sc_build_profile() {
        Log.i((String)TAG, (String)"rtk_sc_gen_random");
        this.rtk_sc_gen_random();
        Log.i((String)TAG, (String)"GenerateKey");
        this.GenerateKey();
        Log.i((String)TAG, (String)"EncryptProfile");
        this.EncryptProfile();
        Log.i((String)TAG, (String)"rtk_sc_build_profile finish");
    }

    public void rtk_sc_start() {
        this.SendEnable = true;
        this.SendThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)0);
                int config_counts = 0;
                long startTime = System.currentTimeMillis();
                long endTime = System.currentTimeMillis();
                while (SCLibrary.this.SendEnable && endTime - startTime < (long)ProfileSendTimeMillis) {
                    try {
                        SCLibrary.this.SendSync();
                        SCLibrary.this.SendData();
                        SCLibrary.this.SendEnd();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (ProfileSendTimeIntervalMs > 0) {
                        try {
                            Thread.sleep(ProfileSendTimeIntervalMs);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    endTime = System.currentTimeMillis();
                    ++config_counts;
                }
                Log.i((String)SCLibrary.TAG, (String)("Config rounds: " + config_counts));
                Log.i((String)SCLibrary.TAG, (String)String.format("Each round packtes: (9+%d)*%d=%d\n", SCParam.RtkSC.CryptLen[0], EachPacketSendCounts, (SCParam.RtkSC.CryptLen[0] + 9) * EachPacketSendCounts));
                Log.i((String)SCLibrary.TAG, (String)("Config Time Elapsed: " + (endTime - startTime) + "ms"));
                Message msg = Message.obtain();
                msg.obj = null;
                msg.what = -1;
                SCLibrary.this.TreadMsgHandler.sendMessage(msg);
            }
        });
        this.SendThread.start();
    }

    public void rtk_sc_stop() {
        this.SendEnable = false;
    }

    public int HandleCfgACK(byte[] recv_buf) {
        String MacStr;
        int i;
        int cfgIndex = 0;
        int MacEqualCnt = 0;
        int length = recv_buf[1] << 8 & 0xFF00 | recv_buf[2] & 0xFF;
        if (length < 13) {
            Log.e((String)TAG, (String)"Received format error\n");
            return -1;
        }
        if (SCParam.RecvACK.MaxCfgNum > 32) {
            Log.e((String)TAG, (String)"Receive buf is full\n");
            return -1;
        }
        if (SCParam.RecvACK.MaxCfgNum > 0) {
            cfgIndex = 0;
            while (cfgIndex < SCParam.RecvACK.MaxCfgNum) {
                i = 0;
                while (i < 6) {
                    if (recv_buf[3 + i] == SCParam.RecvACK.Mac[cfgIndex][i]) {
                        ++MacEqualCnt;
                    }
                    ++i;
                }
                if (MacEqualCnt == 6) break;
                MacEqualCnt = 0;
                ++cfgIndex;
            }
        }
        i = 0;
        while (i < 4) {
            if (recv_buf[12 + i] != 0) break;
            ++i;
        }
        if (i != 4 && SCParam.RecvACK.IP[cfgIndex] != null && SCParam.RecvACK.IP[cfgIndex].length() > 0) {
            System.arraycopy(recv_buf, 3, SCParam.RecvACK.Mac[cfgIndex], 0, 6);
            MacStr = new String();
            i = 0;
            while (i < 6) {
                MacStr = String.valueOf(MacStr) + String.format("%02x", SCParam.RecvACK.Mac[cfgIndex][i]);
                if (i < 5) {
                    MacStr = String.valueOf(MacStr) + ":";
                }
                ++i;
            }
            System.arraycopy(recv_buf, 12, SCParam.RecvACK.IPBuf[cfgIndex], 0, 4);
            SCParam.RecvACK.IP[cfgIndex] = String.format("%d.%d.%d.%d", SCParam.RecvACK.IPBuf[cfgIndex][0] & 0xFF, SCParam.RecvACK.IPBuf[cfgIndex][1] & 0xFF, SCParam.RecvACK.IPBuf[cfgIndex][2] & 0xFF, SCParam.RecvACK.IPBuf[cfgIndex][3] & 0xFF);
            Log.i((String)TAG, (String)("Refresh IP: " + SCParam.RecvACK.IP[cfgIndex] + " of MAC: " + MacStr));
            this.rtk_sc_send_cfg_ack_packet();
        }
        if (MacEqualCnt == 6) {
            return 0;
        }
        System.arraycopy(recv_buf, 3, SCParam.RecvACK.Mac[SCParam.RecvACK.MaxCfgNum], 0, 6);
        MacStr = new String();
        i = 0;
        while (i < 6) {
            MacStr = String.valueOf(MacStr) + String.format("%02x", SCParam.RecvACK.Mac[SCParam.RecvACK.MaxCfgNum][i]);
            if (i < 5) {
                MacStr = String.valueOf(MacStr) + ":";
            }
            ++i;
        }
        Log.i((String)TAG, (String)("Added MAC: " + MacStr));
        if (length > 7) {
            SCParam.RecvACK.Status[SCParam.RecvACK.MaxCfgNum] = recv_buf[9];
        }
        if (length > 9) {
            System.arraycopy(recv_buf, 10, SCParam.RecvACK.Type[SCParam.RecvACK.MaxCfgNum], 0, 2);
        }
        if (length > 13) {
            System.arraycopy(recv_buf, 12, SCParam.RecvACK.IPBuf[SCParam.RecvACK.MaxCfgNum], 0, 4);
            SCParam.RecvACK.IP[SCParam.RecvACK.MaxCfgNum] = String.format("%d.%d.%d.%d", SCParam.RecvACK.IPBuf[SCParam.RecvACK.MaxCfgNum][0] & 0xFF, SCParam.RecvACK.IPBuf[SCParam.RecvACK.MaxCfgNum][1] & 0xFF, SCParam.RecvACK.IPBuf[SCParam.RecvACK.MaxCfgNum][2] & 0xFF, SCParam.RecvACK.IPBuf[SCParam.RecvACK.MaxCfgNum][3] & 0xFF);
            Log.i((String)TAG, (String)("IP: " + SCParam.RecvACK.IP[SCParam.RecvACK.MaxCfgNum]));
            this.rtk_sc_send_cfg_ack_packet();
        }
        if (length > 14) {
            System.arraycopy(recv_buf, 16, SCParam.RecvACK.NameBuf[SCParam.RecvACK.MaxCfgNum], 0, length - 13);
            String name = null;
            try {
                name = new String(SCParam.RecvACK.NameBuf[SCParam.RecvACK.MaxCfgNum], "UTF-8").trim();
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)TAG, (String)"Get device's name error");
                e.printStackTrace();
            }
            SCParam.RecvACK.Name[SCParam.RecvACK.MaxCfgNum] = name.length() > 0 ? name : null;
            Log.i((String)TAG, (String)("Name: " + SCParam.RecvACK.Name[SCParam.RecvACK.MaxCfgNum]));
        }
        ++SCParam.RecvACK.MaxCfgNum;
        Message msg = Message.obtain();
        msg.obj = null;
        msg.what = 0;
        this.TreadMsgHandler.sendMessage(msg);
        return 0;
    }

    public void rtk_sc_send_cfg_ack_packet() {
        int i;
        byte[] CmdBuf = new byte[92];
        Arrays.fill(CmdBuf, (byte)0);
        CmdBuf[0] = (byte)(CmdBuf[0] + 0);
        CmdBuf[0] = (byte)(CmdBuf[0] + 0);
        CmdBuf[0] = (byte)(CmdBuf[0] + 4);
        CmdBuf[1] = 0;
        CmdBuf[2] = 90;
        CmdBuf[3] = 0;
        Message msg = Message.obtain();
        msg.what = 5;
        if (SCParam.RecvACK.IP[0] != null && SCParam.RecvACK.IP[0].length() > 0 && !SCParam.RecvACK.IP[0].equals("0.0.0.0")) {
            SCParam.UDPUcast.IPAddr = SCParam.RecvACK.IP[0];
            SCParam.UDPUcast.SendLen = CmdBuf.length;
            SCParam.UDPUcast.SendMsg = CmdBuf;
            Log.d((String)TAG, (String)"UDPUnicastSend CFG ACK");
            i = 0;
            while (i < 8) {
                this.SCNetOps.UDPUnicastSend();
                ++i;
            }
            msg.obj = "Unicast Send CFG ACK";
        }
        SCParam.UDPBcast.IPAddr = "255.255.255.255";
        SCParam.UDPBcast.SendLen = CmdBuf.length;
        SCParam.UDPBcast.SendMsg = CmdBuf;
        Log.d((String)TAG, (String)"UDPBroadcastSend CFG ACK");
        i = 0;
        while (i < 8) {
            this.SCNetOps.UDPBroadcastSend();
            ++i;
        }
        msg.obj = "Broadcast Send CFG ACK";
        this.TreadMsgHandler.sendMessage(msg);
    }

    private int RtkSCParseResult() {
        int recv_len = SCParam.UDPUcast.RecvLen;
        byte[] recv_buf = new byte[recv_len];
        System.arraycopy(SCParam.UDPUcast.RecvBuf, 0, recv_buf, 0, recv_len);
        if (recv_len < 9) {
            return -1;
        }
        byte flag = recv_buf[0];
        if ((flag & (SCParam.BIT(7) | SCParam.BIT(6))) != 0) {
            Log.e((String)TAG, (String)"ACK version not match\n");
            return -1;
        }
        if ((flag & SCParam.BIT(5)) != 32) {
            Log.e((String)TAG, (String)"Not response ACK\n");
            return -1;
        }
        Message msg = Message.obtain();
        switch (flag & 0x1F) {
            case 0: {
                this.SendEnable = false;
                int ack_ret = this.HandleCfgACK(recv_buf);
                return ack_ret;
            }
            case 1: {
                msg.obj = recv_buf;
                msg.what = 1;
                this.TreadMsgHandler.sendMessage(msg);
                break;
            }
            case 2: {
                msg.obj = recv_buf;
                msg.what = 2;
                this.TreadMsgHandler.sendMessage(msg);
                break;
            }
            case 3: {
                msg.obj = recv_buf;
                msg.what = 3;
                this.TreadMsgHandler.sendMessage(msg);
                break;
            }
            case 4: {
                msg.obj = recv_buf;
                msg.what = 4;
                this.TreadMsgHandler.sendMessage(msg);
                break;
            }
            default: {
                Log.e((String)TAG, (String)"Unknow response");
            }
        }
        return 0;
    }

    public void RtkSCRecvThread() {
        this.RecvEnable = true;
        this.RecvThread = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean res = false;
                while (SCLibrary.this.RecvEnable) {
                    res = false;
                    try {
                        res = SCLibrary.this.RecvData();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!res) continue;
                    try {
                        SCLibrary.this.RtkSCParseResult();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Log.e((String)SCLibrary.TAG, (String)"Parse Result Error");
                        break;
                    }
                }
            }
        });
        this.RecvThread.start();
    }

    public int rtk_sc_get_connected_sta_num() {
        return SCParam.RecvACK.MaxCfgNum;
    }

    public int rtk_sc_get_connected_sta_info(List<HashMap<String, Object>> DevInfo) {
        int index = 0;
        while (index < SCParam.RecvACK.MaxCfgNum) {
            String buf = new String();
            HashMap<String, String> hmap = new HashMap<String, String>();
            int i = 0;
            while (i < 6) {
                buf = String.valueOf(buf) + String.format("%02x", SCParam.RecvACK.Mac[index][i]);
                if (i < 5) {
                    buf = String.valueOf(buf) + ":";
                }
                ++i;
            }
            hmap.put("MAC", buf);
            buf = new String();
            switch (SCParam.RecvACK.Status[index]) {
                case 1: {
                    buf = "Connected";
                    break;
                }
                case 2: {
                    buf = "Profile saved";
                    break;
                }
                default: {
                    buf = "Unkown status";
                }
            }
            hmap.put("Status", buf);
            buf = new String();
            short type = (short)((SCParam.RecvACK.Type[index][0] & 0xFF00) + (SCParam.RecvACK.Type[index][1] & 0xFF));
            switch (type) {
                case 0: {
                    buf = "Any type";
                    break;
                }
                case 1: {
                    buf = "TV";
                    break;
                }
                case 2: {
                    buf = "Air conditioner";
                    break;
                }
                default: {
                    buf = "Unkown type";
                }
            }
            hmap.put("Type", buf);
            hmap.put("IP", SCParam.RecvACK.IP[index]);
            hmap.put("Name", SCParam.RecvACK.Name[index]);
            DevInfo.add(hmap);
            ++index;
        }
        return 0;
    }

    public int rtk_sc_send_discover_packet(byte[] cmdbuf, String send_ip) {
        try {
            SCParam.UDPBcast.IPAddr = send_ip;
            SCParam.UDPBcast.SendLen = cmdbuf.length;
            SCParam.UDPBcast.SendMsg = cmdbuf;
            this.SCNetOps.UDPBroadcastSend();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int rtk_sc_send_control_packet(byte[] cmdbuf, String send_ip) {
        try {
            SCParam.UDPUcast.IPAddr = send_ip;
            SCParam.UDPUcast.SendLen = cmdbuf.length;
            SCParam.UDPUcast.SendMsg = cmdbuf;
            this.SCNetOps.UDPUnicastSend();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }
}

