/*
 * Decompiled with CFR 0.152.
 */
package com.realtek.simpleconfiglib;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import com.realtek.simpleconfiglib.SCParam;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;

public class SCNetworkOps {
    private static final String TAG = "SCNetworkOps";
    private WifiManager SCWifiMngr;
    private WifiInfo SCWifiInfo;
    private static String macAddr;
    private Context context;

    public static long IP2Integer(String ip) {
        String[] items = ip.split("\\.");
        return Long.valueOf(items[0]) << 24 | Long.valueOf(items[1]) << 16 | Long.valueOf(items[2]) << 8 | Long.valueOf(items[3]);
    }

    public static String Integer2IP(int ipInt) {
        StringBuilder sb = new StringBuilder();
        sb.append(ipInt & 0xFF).append(".");
        sb.append(ipInt >> 8 & 0xFF).append(".");
        sb.append(ipInt >> 16 & 0xFF).append(".");
        sb.append(ipInt >> 24 & 0xFF);
        return sb.toString();
    }

    public void WifiInit(Context context) {
        this.context = context;
        this.SCWifiMngr = (WifiManager)context.getSystemService("wifi");
        this.SCWifiInfo = this.SCWifiMngr.getConnectionInfo();
        macAddr = this.SCWifiInfo == null ? null : this.SCWifiInfo.getMacAddress();
    }

    public void WifiOpen() {
        if (!this.SCWifiMngr.isWifiEnabled()) {
            this.SCWifiMngr.setWifiEnabled(true);
        }
    }

    public void WifiClose() {
        if (this.SCWifiMngr.isWifiEnabled()) {
            this.SCWifiMngr.setWifiEnabled(false);
        }
    }

    public void WifiStartScan() {
        this.SCWifiMngr.startScan();
    }

    public List<ScanResult> WifiGetScanResults() {
        return this.SCWifiMngr.getScanResults();
    }

    public List<WifiConfiguration> WifiGetConfiguredNetworks() {
        return this.SCWifiMngr.getConfiguredNetworks();
    }

    public int WifiStatus() {
        return this.SCWifiMngr.getWifiState();
    }

    public String WifiAvailable() {
        return "android.net.wifi.SCAN_RESULTS";
    }

    public boolean isWifiConnected(String ssid) {
        ConnectivityManager connManager;
        NetworkInfo mWifi;
        WifiInfo wifiInfo = this.SCWifiMngr.getConnectionInfo();
        String ssidGet = wifiInfo.getSSID();
        if (ssidGet == null) {
            Log.e((String)TAG, (String)"Get SSID Error");
            return false;
        }
        return (ssidGet.equals(new String("\"" + ssid + "\"")) || ssidGet.equals(new String(ssid))) && (mWifi = (connManager = (ConnectivityManager)this.context.getSystemService("connectivity")).getNetworkInfo(1)).isConnected();
    }

    public String getConnectedWifiSSID() {
        WifiInfo wifiInfo = this.SCWifiMngr.getConnectionInfo();
        return wifiInfo.getSSID();
    }

    public String WifiGetMacStr() {
        return macAddr;
    }

    public int WifiGetIpInt() {
        WifiInfo wifiInfo = this.SCWifiMngr.getConnectionInfo();
        return wifiInfo == null ? 0 : wifiInfo.getIpAddress();
    }

    public void BcastSocketCreate() {
        try {
            SCParam.UDPBcast.BcastSock = new DatagramSocket(SCParam.UDPBcast.SrcPort);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            System.out.printf("Broadcast Socket Create Error", new Object[0]);
            return;
        }
    }

    public void BcastSocketDestroy() {
        if (SCParam.UDPBcast.BcastSock != null) {
            SCParam.UDPBcast.BcastSock.close();
        }
    }

    public void McastSocketCreate() {
        try {
            SCParam.UDPMcast.McastSock = new MulticastSocket(SCParam.UDPMcast.SrcPort);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            System.out.printf("Multicast Socket Create Error", new Object[0]);
            return;
        }
    }

    public void McastSocketDestroy() {
        if (SCParam.UDPMcast.McastSock != null) {
            SCParam.UDPMcast.McastSock.close();
        }
    }

    public void UnicastSocketCreate() {
        try {
            SCParam.UDPUcast.UcastSock = new DatagramSocket(SCParam.UDPUcast.SrcPort);
        }
        catch (SocketException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"Unicast Socket Create Error");
            return;
        }
    }

    public void UnicastSocketDestroy() {
        if (SCParam.UDPUcast.UcastSock != null) {
            SCParam.UDPUcast.UcastSock.close();
        }
    }

    public void UDPBroadcastSend() {
        InetAddress uAddress = null;
        try {
            uAddress = InetAddress.getByName(SCParam.UDPBcast.IPAddr);
        }
        catch (UnknownHostException e2) {
            e2.printStackTrace();
        }
        if (uAddress == null) {
            System.out.printf("Get InetAddress error!", new Object[0]);
            return;
        }
        DatagramPacket dgPkt = new DatagramPacket(SCParam.UDPBcast.SendMsg, SCParam.UDPBcast.SendLen, uAddress, SCParam.UDPBcast.DestPort);
        try {
            SCParam.UDPBcast.BcastSock.send(dgPkt);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"UDP Broadcast Send Error");
            return;
        }
    }

    public void SCUDPMulticastSend() {
        SCParam.UDPMcast.SendMsg = new byte[SCParam.UDPMcast.SendLen];
        this.UDPMulticastSend();
    }

    public void UDPMulticastSend() {
        InetAddress mAddress = null;
        try {
            mAddress = InetAddress.getByName(SCParam.UDPMcast.IPAddr);
            if (!mAddress.isMulticastAddress()) {
                Log.e((String)TAG, (String)"Wrong Multicast Address");
                return;
            }
        }
        catch (UnknownHostException e2) {
            e2.printStackTrace();
            Log.e((String)TAG, (String)"Get Multicast Address error");
            return;
        }
        try {
            SCParam.UDPMcast.McastSock.joinGroup(mAddress);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            Log.e((String)TAG, (String)"Join Multicast Group error");
        }
        DatagramPacket dgPkt = new DatagramPacket(SCParam.UDPMcast.SendMsg, SCParam.UDPMcast.SendLen, mAddress, SCParam.UDPMcast.DestPort);
        try {
            SCParam.UDPMcast.McastSock.send(dgPkt);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"Multicast Send error");
        }
        try {
            SCParam.UDPMcast.McastSock.leaveGroup(mAddress);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void UDPUnicastSend() {
        InetAddress uAddress = null;
        try {
            uAddress = InetAddress.getByName(SCParam.UDPUcast.IPAddr);
        }
        catch (UnknownHostException e2) {
            e2.printStackTrace();
        }
        if (uAddress == null) {
            System.out.printf("Get InetAddress error!", new Object[0]);
            return;
        }
        DatagramPacket dgPkt = new DatagramPacket(SCParam.UDPUcast.SendMsg, SCParam.UDPUcast.SendLen, uAddress, SCParam.UDPUcast.DestPort);
        try {
            SCParam.UDPUcast.UcastSock.send(dgPkt);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"UDP Send Error");
            return;
        }
    }

    public boolean UDPUnicastRecv() {
        DatagramPacket dgPacket = null;
        try {
            dgPacket = new DatagramPacket(SCParam.UDPUcast.RecvBuf, SCParam.UDPUcast.RecvBuf.length);
            if (dgPacket != null) {
                SCParam.UDPUcast.UcastSock.receive(dgPacket);
            }
        }
        catch (IOException e) {
            return false;
        }
        SCParam.UDPUcast.RecvLen = dgPacket.getLength();
        return true;
    }
}

