/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.iot.esptouch;

import android.content.Context;
import android.util.Log;
import com.espressif.iot.esptouch.Esptouch1;

public class Esptouch {
    private String TAG = "Esptouch";
    private volatile Esptouch1 mEsptouch1;
    private volatile boolean mIsEsptouch1StartSuc;
    private volatile long mStartTimestamp = -1L;
    private volatile long mTimeout = -1L;

    private Esptouch() {
    }

    public static Esptouch getInstance() {
        return InstanceHolder.instance;
    }

    private boolean isTimeout() {
        if (this.mStartTimestamp < 0L || this.mTimeout < 0L) {
            return true;
        }
        boolean isTimeout = System.currentTimeMillis() > this.mStartTimestamp + this.mTimeout;
        return isTimeout;
    }

    public synchronized void start(String ssid, String psw, Context context, int timeout) {
        Log.d((String)this.TAG, (String)("Esptouch start() ssid:" + ssid + ",psw:" + psw + ",timeout:" + timeout));
        if (this.isRunning()) {
            Log.w((String)this.TAG, (String)"Esptouch start(): one task is running, so stop it before start a new one");
            this.stop();
        }
        this.mEsptouch1 = new Esptouch1();
        this.mIsEsptouch1StartSuc = this.mEsptouch1.start(ssid, psw, context, timeout);
        this.mTimeout = timeout * 1000;
        this.mStartTimestamp = System.currentTimeMillis() + 100L;
    }

    public synchronized void stop() {
        Log.d((String)this.TAG, (String)"Esptouch stop()");
        if (this.mEsptouch1 != null) {
            this.mEsptouch1.stop();
            this.mEsptouch1 = null;
            this.mIsEsptouch1StartSuc = false;
            this.mStartTimestamp = -1L;
            this.mTimeout = -1L;
        }
    }

    public synchronized boolean isRunning() {
        if (this.mEsptouch1 != null && this.mIsEsptouch1StartSuc) {
            return !this.isTimeout();
        }
        return false;
    }

    /* synthetic */ Esptouch(Esptouch esptouch) {
        this();
    }

    private static class InstanceHolder {
        static Esptouch instance = new Esptouch(null);

        private InstanceHolder() {
        }
    }
}

