/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.iot.esptouch;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import com.espressif.iot.esptouch.EsptouchTask;
import com.espressif.iot.esptouch.IEsptouchTask;
import java.util.Collections;
import java.util.List;

public class Esptouch1 {
    private static final String TAG = "Esptouch1";
    private Context mContext;
    private IEsptouchTask mTask;

    private List<ScanResult> scan() {
        WifiManager mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        mWifiManager.startScan();
        List wifiList = null;
        wifiList = mWifiManager.getScanResults();
        if (wifiList != null) {
            return wifiList;
        }
        return Collections.emptyList();
    }

    private WifiInfo getConnectionInfo() {
        WifiManager mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        WifiInfo wifiInfo = mWifiManager.getConnectionInfo();
        return wifiInfo;
    }

    private String getSsid(WifiInfo wifiInfo) {
        String ssid = null;
        if (wifiInfo != null) {
            int len = wifiInfo.getSSID().length();
            ssid = wifiInfo.getSSID().startsWith("\"") && wifiInfo.getSSID().endsWith("\"") ? wifiInfo.getSSID().substring(1, len - 1) : wifiInfo.getSSID();
        }
        return ssid;
    }

    private String getBssid(String ssid) {
        String apSsid;
        WifiInfo apInfo = this.getConnectionInfo();
        if (apInfo != null && ssid.equals(apSsid = this.getSsid(apInfo))) {
            return apInfo.getBSSID();
        }
        List<ScanResult> scanResultList = null;
        int retry = 0;
        while (retry < 10) {
            if (retry > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            scanResultList = this.scan();
            for (ScanResult scanResult : scanResultList) {
                if (!ssid.equals(scanResult.SSID)) continue;
                String bssid = scanResult.BSSID;
                return bssid;
            }
            ++retry;
        }
        return null;
    }

    public synchronized boolean start(String ssid, String psw, Context context, int timeout) {
        if (this.mTask != null) {
            Log.e((String)TAG, (String)"Esptouch1 ERROR: task is executing, do nothing else");
            return false;
        }
        this.mContext = context;
        String bssid = this.getBssid(ssid);
        if (bssid != null) {
            String apSsid = ssid;
            String apBssid = bssid;
            String apPassword = psw;
            boolean isSsidHidden = true;
            int timeoutMillisecond = timeout * 1000;
            this.mTask = new EsptouchTask(apSsid, apBssid, apPassword, isSsidHidden, timeoutMillisecond, context);
            new Thread(){

                @Override
                public void run() {
                    Esptouch1.this.mTask.executeForResults(0);
                }
            }.start();
            return true;
        }
        Log.w((String)TAG, (String)"Esptouch1 WARN: can't get bssid by ssid");
        return false;
    }

    public synchronized void stop() {
        if (this.mTask != null) {
            this.mTask.interrupt();
        }
    }
}

