/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.iot.esptouch.udp;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.util.Log;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Arrays;

public class UDPSocketServer {
    private static final String TAG = "UDPSocketServer";
    private DatagramPacket mReceivePacket;
    private DatagramSocket mServerSocket;
    private Context mContext;
    private WifiManager.MulticastLock mLock;
    private final byte[] buffer;
    private volatile boolean mIsClosed;

    private synchronized void acquireLock() {
        if (this.mLock != null && !this.mLock.isHeld()) {
            this.mLock.acquire();
        }
    }

    private synchronized void releaseLock() {
        if (this.mLock != null && this.mLock.isHeld()) {
            try {
                this.mLock.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public UDPSocketServer(int port, int socketTimeout, Context context) {
        this.mContext = context;
        this.buffer = new byte[64];
        this.mReceivePacket = new DatagramPacket(this.buffer, 64);
        try {
            this.mServerSocket = new DatagramSocket(port);
            this.mServerSocket.setSoTimeout(socketTimeout);
            this.mIsClosed = false;
            WifiManager manager = (WifiManager)this.mContext.getSystemService("wifi");
            this.mLock = manager.createMulticastLock("test wifi");
            Log.d((String)TAG, (String)("mServerSocket is created, socket read timeout: " + socketTimeout + ", port: " + port));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOException");
            e.printStackTrace();
        }
    }

    public boolean setSoTimeout(int timeout) {
        try {
            this.mServerSocket.setSoTimeout(timeout);
            return true;
        }
        catch (SocketException e) {
            e.printStackTrace();
            return false;
        }
    }

    public byte receiveOneByte() {
        Log.d((String)TAG, (String)"receiveOneByte() entrance");
        try {
            this.acquireLock();
            this.mServerSocket.receive(this.mReceivePacket);
            Log.d((String)TAG, (String)("receive: " + (0 + this.mReceivePacket.getData()[0])));
            return this.mReceivePacket.getData()[0];
        }
        catch (IOException e) {
            e.printStackTrace();
            return -128;
        }
    }

    public byte[] receiveSpecLenBytes(int len) {
        byte[] recDatas;
        block4: {
            Log.d((String)TAG, (String)("receiveSpecLenBytes() entrance: len = " + len));
            try {
                this.acquireLock();
                this.mServerSocket.receive(this.mReceivePacket);
                recDatas = Arrays.copyOf(this.mReceivePacket.getData(), this.mReceivePacket.getLength());
                Log.d((String)TAG, (String)("received len : " + recDatas.length));
                int i = 0;
                while (i < recDatas.length) {
                    Log.e((String)TAG, (String)("recDatas[" + i + "]:" + recDatas[i]));
                    ++i;
                }
                Log.e((String)TAG, (String)("receiveSpecLenBytes: " + new String(recDatas)));
                if (recDatas.length == len) break block4;
                Log.w((String)TAG, (String)"received len is different from specific len, return null");
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return recDatas;
    }

    public void interrupt() {
        Log.i((String)TAG, (String)"USPSocketServer is interrupt");
        this.close();
    }

    public synchronized void close() {
        if (!this.mIsClosed) {
            Log.e((String)TAG, (String)"mServerSocket is closed");
            this.mServerSocket.close();
            this.releaseLock();
            this.mIsClosed = true;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

