/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.iot.esptouch.util;

import java.util.zip.Checksum;

public class CRC8
implements Checksum {
    private final short init;
    private static final short[] crcTable = new short[256];
    private short value = 0;
    private static final short CRC_POLYNOM = 140;
    private static final short CRC_INITIAL = 0;

    static {
        int dividend = 0;
        while (dividend < 256) {
            int remainder = dividend;
            int bit = 0;
            while (bit < 8) {
                remainder = (remainder & 1) != 0 ? remainder >>> 1 ^ 0x8C : (remainder >>>= 1);
                ++bit;
            }
            CRC8.crcTable[dividend] = (short)remainder;
            ++dividend;
        }
    }

    public CRC8() {
        this.init = 0;
    }

    @Override
    public void update(byte[] buffer, int offset, int len) {
        int i = 0;
        while (i < len) {
            int data = buffer[offset + i] ^ this.value;
            this.value = (short)(crcTable[data & 0xFF] ^ this.value << 8);
            ++i;
        }
    }

    @Override
    public void update(byte[] buffer) {
        this.update(buffer, 0, buffer.length);
    }

    @Override
    public void update(int b) {
        this.update(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public long getValue() {
        return this.value & 0xFF;
    }

    @Override
    public void reset() {
        this.value = this.init;
    }
}

